<div class="row justify-content-center pt-3">
    <div class="col">
        <div class="">
            <div  class="card-body head-table-no-suggestion">
                
                <table class="my-table" style="width:100%">
                    <thead>
                        <tr>
                            <th style="border-top-left-radius: .5rem">Code</th>
                            <th>Name</th>
                            <th class="text-center">Qty</th>
                            <th class="text-center">Price</th>
                            <th class="text-center">Discount</th>
                            <th class="text-center" style="border-top-right-radius: .5rem">Sub Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr wire:key="cart-<?php echo e($cart['id']); ?>">
                                <td style="font-weight: 500"><?php echo e($cart['code']); ?></td>
                                <td data-bs-toggle="modal" data-bs-target="#modalCart" style="cursor: pointer">
                                    <?php echo e($cart['name']); ?></td>
                                <td width="68px" class="stop-propagation">
                                    <input class="quantity-input <?php if($cart['maxpack'] === 'N'): ?> border-0 <?php endif; ?>"
                                        type="number" id="<?php echo e($cart['code']); ?>"
                                        wire:change="sameCart(<?php echo e($cart['id']); ?>, $event.target.value)"
                                        value="<?php echo e($cart['qty']); ?>" onchange="updateQuantity(this, <?php echo e($cart['id']); ?>)"
                                        onpaste="handlePaste(event)" <?php if(!Str::startsWith($cart['code'], ['FG', 'BUY', 'VOUCHER'])): ?> min="1" <?php endif; ?>
                                        <?php if($cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free'): ?> disabled <?php endif; ?>>
                                    


                                </td>
                                <td class="text-center">
                                    <?php echo e('Rp ' . number_format($cart['nprice'], 0, ',', '.')); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo e('Rp ' . number_format($cart['nprice'] - $cart['price'], 0, ',', '.')); ?></td>
                                <td class="text-center">
                                    <?php echo e('Rp ' . number_format($cart['price'] * $cart['qty'], 0, ',', '.')); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    

    

    <div style="border-radius: 0.25rem; margin-bottom: -3rem;">
        <div class="row body-charsier-3">
            <div class="col-lg-3 col-md-12 col-sm-12" x-data="{ selectedIndexSales: null }" x-init="selectedIndexSales = -1">
                <!-- Adjusted column size -->
                <div class="">
                    <div class="">
                        <div class="d-flex gap-1 align-items-center">
                            <label class="font-salesEmp">Sales Employee</label>
                            <h6 class="shortcut">F3</h6>
                        </div>
                        <input type="text" class="form-control fw-medium mt-2" id="sales_employee"
                            wire:model.live="form.sales" placeholder="No Sales Employee" hidden>
                        <input type="text" class="form-control fw-medium mt-2" id="sales_employee"
                            wire:model.debounce.100ms.live="searchsales" placeholder="No Sales Employee" autofocus
                            autocomplete="off"
                            @keydown.arrow-down.prevent="selectedIndexSales = Math.min(selectedIndexSales + 1, <?php echo e(count($sales) - 1); ?>)"
                            @keydown.arrow-up.prevent="selectedIndexSales = Math.max(selectedIndexSales - 1, -1)"
                            x-on:keydown.enter="
                                if(selectedIndexSales == -1) {
                                
                                } else {
                                    $wire.selectSales(selectedIndexSales);
                                    selectedIndexSales = -1; 
                                }">
                        <!--[if BLOCK]><![endif]--><?php if($selectedSales === null && $isDropdownsalesVisible): ?>
                            <div class="dropdown-menu border-dark-subtle d-block py-0">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexSales === <?php echo e($index); ?> }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link" id="ddown-style"
                                                wire:click="selectSalesByClick('<?php echo e($sale->code); ?>')"
                                                :class="{ 'text-white': selectedIndexSales === <?php echo e($index); ?> }">
                                                <?php echo e($sale->code); ?> || <?php echo e($sale->name); ?>

                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>

                    
                </div>
            </div>

            <div class="qty-grup col-lg-7 col-md-12 col-sm-12">
                <div class="qty-sub-2">
                    <div>
                        <p class="font-salesEmp">Quantity</p>
                        <h3 class="sub-total">
                            <?php echo e($carttotal->sum('qty')); ?>

                        </h3>
                    </div>
                </div>

                <div class="qty-sub">
                    <div>
                        <p class="font-salesEmp">Sub Total</p>
                        <h3 class="sub-total">
                            <!--[if BLOCK]><![endif]--><?php if($carttotal->isEmpty()): ?>
                                Rp
                            <?php else: ?>
                                <?php echo e('Rp ' . number_format($carttotal->sum('total_price'), 0, ',', '.')); ?>

                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                </div>
            </div>

            

            <div class="col-lg-2 col-md-12 col-sm-12 text-primary text-right payment-button" style="">
                <!--[if BLOCK]><![endif]--><?php if($this->selectedSales === null): ?>
                    <div class="d-flex justify-content-center align-items-center">
                        <button type="button" data-bs-target="#salesModal" data-bs-toggle="modal" class="button-try">
                            <div class="d-flex justify-content-center align-items-center gap-2">
                                <div class="text-white ">Pay</div>
                                <h6 class="fst-italic"
                                    style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; padding: 3px; fw-bold">
                                    F4</h6>
                            </div>
                        </button>
                    </div>
                <?php else: ?>
                    <div class="d-flex justify-content-center align-items-center">
                        <button type="button"
                            <?php if(!empty($carts)): ?> data-bs-toggle="modal" 
                        wire:click="createInvoiceOpen"
                        <?php else: ?> 
                        wire:click="cartEmpty" <?php endif; ?>
                            class="button-try">
                            <div class="d-flex justify-content-center align-items-center gap-2">
                                <div class="text-white ">Pay</div>
                                <h6 class="fst-italic"
                                    style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; padding: 3px; fw-bold">
                                    F4</h6>
                            </div>
                        </button>
                    </div>
                <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>

    <input type="hidden" wire:keydown.window.shift.backspace="deleteLatestCart">
    <div wire:ignore.self class="modal fade" id="modalCart" tabindex="-1" aria-labelledby="modalCartLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCartLabel">Carts</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr wire:key="cart-<?php echo e($cart['id']); ?>">
                                    <td><?php echo e($cart['code']); ?></td>
                                    <td><?php echo e($cart['name']); ?></td>
                                    <td>
                                        <?php echo e('Rp ' . number_format($cart['price'], 0, ',', '.')); ?>

                                    </td>
                                    <td width="80px">
                                        <input class="form-control form-control-sm quantity-input" type="number"
                                            id="<?php echo e($cart['code']); ?>"
                                            wire:change="sameCart(<?php echo e($cart['id']); ?>, $event.target.value)"
                                            value="<?php echo e($cart['qty']); ?>"
                                            onchange="updateQuantity(this, <?php echo e($cart['id']); ?>)"
                                            onpaste="handlePaste(event)"
                                            <?php if(!Str::startsWith($cart['code'], ['FG', 'BUY', 'VOUCHER'])): ?> min="1" <?php endif; ?>
                                            <?php if($cart['benefit'] == 'Cheapest' || $cart['benefit'] == 'Free'): ?> disabled <?php endif; ?>>
                                        

                                    </td>
                                    <td class="text-center">
                                        <button wire:click="deleteCart(<?php echo e($cart['id']); ?>)"
                                            wire:loading.attr="disabled" class="badge button-custom-danger"
                                            type="button"
                                            <?php echo e($cart['benefit'] == 'Free' || $cart['benefit'] == 'Cheapest' ? 'disabled' : ''); ?>>
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr class="text-center" width="100%">
                                    <td colspan="6">
                                        Empty
                                    </td>
                                </tr>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

<script>
    function updateQuantity(input, cartId) {
        var code = input.id;
        var quantity = parseInt(input.value);

        if (!code.startsWith('FG') && !code.startsWith('BUY') && !code.startsWith('VOUCHER')) {
            if (isNaN(quantity) || quantity < 1) {
                quantity = 1;
            }
        }
        input.value = quantity;
    }

    function handlePaste(event) {
        var clipboardData, pastedData;

        event.stopPropagation();
        event.preventDefault();

        clipboardData = event.clipboardData || window.clipboardData;
        pastedData = clipboardData.getData('Text');

        // Check if pasted data is a valid positive number
        var parsedValue = parseFloat(pastedData);
        if (!isNaN(parsedValue) && parsedValue >= 0) {
            // Update the input value
            var input = event.target;
            input.value = parsedValue;
            input.dispatchEvent(new Event('input'));
        }
    }

    window.addEventListener('keydown', function(event) {
        if (event.key === 'F3') {
            event.preventDefault();
            if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').modalOpen) {
                Livewire.dispatch('F3ModalOpen');
            } else {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').salesModal();
            }
            console.log('press f3')
        }
        if (event.key === 'F4') {

            event.preventDefault();
            if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').isSalesModalVisible) {

            } else {
                if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').modalOpen) {
                    Livewire.dispatch('F4ModalOpen');
                } else {
                    if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').isCarts.length > 0) {
                        if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').selectedSales) {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').createInvoice();
                        } else {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').salesModal();
                        }
                    } else {
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').cartEmpty();
                    }
                }
                console.log('press f4')
            }

        }
    });

    Livewire.on('createInvoice', () => {
        $('#invoiceModal').modal('show');
    });
    Livewire.on('closePayment', () => {
        $('#invoiceModal').modal('hide');
        Livewire.dispatch('resetPayment');
    });
</script>
<?php /**PATH C:\laragon\www\Posprorycroft\resources\views/livewire/cashier/table.blade.php ENDPATH**/ ?>