<div wire:ignore.self class="modal fade modal-xl" id="modalDetail" aria-hidden="true" aria-labelledby="modalDetailLabel2" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="modalDetailLabel2">Detail Invoice - <?php echo e($datadetail[0]->invoice); ?> </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="close" aria-label="Close"></button>
          </div>
          <div class="modal-body">
              <table class="table table-striped" style="width:100%">
                <thead>
                    <tr> 
                        <th style="text-align: center">Tanggal</th>
                        <th style="text-align: center">Staff</th>
                        <th style="text-align: center">Member</th>
                        <th style="text-align: center">Item Code</th>
                        <th style="text-align: center">Item Barcode</th>
                        <th style="text-align: center">Item Name</th>
                        <th style="text-align: center">Qty</th>
                        <th style="text-align: center">Price</th>
                        <th style="text-align: center">Disc</th>
                        <th style="text-align: center">Total Disc</th>
                        <th style="text-align: center">Sub Total</th>
                        <th style="text-align: center">Grand Total</th>
                    </tr>
                </thead>
              <tbody>              
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $datadetail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($invoice->created_at)->format('d/m/y')); ?></td>
                    <td><?php echo e($invoice->sales_name); ?></td>
                    
                    <!--[if BLOCK]><![endif]--><?php if(isset($invoice->id_member)): ?>
                        <td><?php echo e($invoice->member_name); ?></td>
                    <?php else: ?>
                        <td> - </td>
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
            
                    <td>`<?php echo e($invoice->code); ?>`</td>
                    <td>`<?php echo e($invoice->barcode); ?>`</td>
                    <td><?php echo e($invoice->name); ?></td>
                    <td><?php echo e($invoice->qty); ?></td>
                    <td>Rp. <?php echo e(number_format($invoice->nprice, 0, ',', '.')); ?></td>
                    <td>Rp. <?php echo e(number_format($invoice->nprice - $invoice->price, 0, ',', '.')); ?></td>
                    <td>Rp. <?php echo e(number_format(($invoice->nprice - $invoice->price) * abs($invoice->qty), 0, ',', '.')); ?></td>
                    <td>Rp. <?php echo e(number_format($invoice->nprice * $invoice->qty, 0, ',', '.')); ?></td>
                    <td>Rp. <?php echo e(number_format($invoice->total_price, 0, ',', '.')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
            
              </tbody>
          </table>
          </div>
        </div>
      </div>
    
    </div>
    
    <?php /**PATH C:\laragon\www\rybc\resources\views/livewire/report/modaldetail.blade.php ENDPATH**/ ?>