<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center mt-4 mb-2 breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="<?php echo e(route('it.itreqout')); ?>"><?php echo e(__('IT Request Out')); ?> </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <?php echo e(__('Create IT Request Out')); ?>

                    </li>
                </ol>
            </div>
        </nav>
        <div class="row">
            <div class="col-sm-4 col-md-4 col-lg-3">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="dateInput">Date</label>

                        <input type="date" class="form-control rounded" id="dateInput" wire:model.live="date"
                            placeholder="Choose Date" autocomplete="off">
                    </div>
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouse: null }" x-init="selectedIndexWarehouse = -1">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="searchItemInput">From Warehouse</label>
                        <input type="text" class="form-control rounded"
                            wire:model.debounce.100ms.live="searchwarehouse" id="searchWarehouseInput"
                            placeholder="Search Warehouse"
                            @keydown.arrow-down.prevent="selectedIndexWarehouse = Math.min(selectedIndexWarehouse + 1, 10)"
                            @keydown.arrow-up.prevent="selectedIndexWarehouse = Math.max(selectedIndexWarehouse - 1, -1)"
                            x-on:keydown.enter="
                if(selectedIndexWarehouse == -1) {

                }else{
                    $wire.selectWarehouse(selectedIndexWarehouse);
                    selectedIndexWarehouse = -1;
                }"
                            autocomplete="off">
                    </div>
                    <!--[if BLOCK]><![endif]--><?php if($selectedWarehouse === null): ?>
                        <!--[if BLOCK]><![endif]--><?php if($resultwarehouse): ?>
                            <div class="dropdown-menu d-block py-0">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $resultwarehouse; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndexWarehouse === <?php echo e($index); ?> }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button" class="btn btn-link"
                                                :class="{ 'text-white': selectedIndexWarehouse === <?php echo e($index); ?> }"
                                                wire:click="selectWarehouseByClick('<?php echo e($item->code); ?>')">
                                                <?php echo e($item->code); ?> || <?php echo e($item->name); ?>

                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
            <div class="col-sm-4 col-md-4 col-lg-3">
                <div class="form-group">
                    <div class="d-flex" style="flex-direction: column">
                        <label for="textAreaInput">Remarks</label>
                        <textarea class="form-control rounded" id="textAreaInput" placeholder="Enter details" rows="1"
                            style="width: 500px;" wire:model.live="remarks" autocomplete="off"></textarea>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger d-block mt-1"> <?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
        <!--[if BLOCK]><![endif]--><?php if($selectedWarehouse): ?>
            <div class="row mt-2">

                <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexWarehouseto: null }" x-init="selectedIndexWarehouseto = -1">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="searchItemInput">To Warehouse</label>
                            <input type="text" class="form-control rounded"
                                wire:model.debounce.100ms.live="searchwarehouseto" id="searchWarehouseInput"
                                placeholder="Search Warehouse"
                                @keydown.arrow-down.prevent="selectedIndexWarehouseto = Math.min(selectedIndexWarehouseto + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexWarehouseto = Math.max(selectedIndexWarehouseto - 1, -1)"
                                x-on:keydown.enter="
                    if(selectedIndexWarehouseto == -1) {
                    }else{
                        $wire.selectWarehouseto(selectedIndexWarehouseto);
                        selectedIndexWarehouseto = -1;
                    }"
                                autocomplete="off">
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($selectedWarehouseto === null): ?>
                            <!--[if BLOCK]><![endif]--><?php if($resultwarehouseto): ?>
                                <div class="dropdown-menu d-block py-0">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $resultwarehouseto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexWarehouseto === <?php echo e($index); ?> }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexWarehouseto === <?php echo e($index); ?> }"
                                                    wire:click="selectWarehousetoByClick('<?php echo e($item->code); ?>')">
                                                    <?php echo e($item->code); ?> || <?php echo e($item->name); ?>

                                                </button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
                <div class="col-sm-4 col-md-4 col-lg-3" x-data="{ selectedIndexItem: null }" x-init="selectedIndexItem = -1">
                    <div class="form-group">
                        <div class="d-flex" style="flex-direction: column">
                            <label for="searchItemInput">Item</label>
                            <input type="text" class="form-control rounded"
                                wire:model.live="searchitem" id="searchItemInput"
                                placeholder="Select Item"
                                @keydown.arrow-down.prevent="selectedIndexItem = Math.min(selectedIndexItem + 1, 10)"
                                @keydown.arrow-up.prevent="selectedIndexItem = Math.max(selectedIndexItem - 1, -1)"
                                x-on:keydown.enter="
                    if(selectedIndexItem == -1) {
                             $wire.selectItemByBarcode();
                    }else{
                        $wire.selectItem(selectedIndexItem);
                        selectedIndexItem = -1;
                    }"
                                autocomplete="off">
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($selectedItem === null): ?>
                            <!--[if BLOCK]><![endif]--><?php if($resultitem): ?>
                                <div class="dropdown-menu d-block py-0">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $resultitem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndexItem === <?php echo e($index); ?> }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndexItem === <?php echo e($index); ?> }"
                                                    wire:click="selectItemByClick('<?php echo e($item->code); ?>')">
                                                    <?php echo e($item->code); ?> || <?php echo e($item->name); ?>

                                                </button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card-body">
                        <div class="py-12">
                            <div class="table-responsive head-table-no-suggestion">
                                
                                <table class="my-table" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th scope="col" style="border-top-left-radius: 1rem">#</th>
                                            <th scope="col"><?php echo e(__('Code')); ?></th>
                                            <th scope="col"><?php echo e(__('Barcode')); ?></th>
                                            <th scope="col"><?php echo e(__('Name')); ?></th>
                                            <th scope="col"><?php echo e(__('Qty')); ?></th>
                                            <th scope="col"><?php echo e(__('Price')); ?></th>
                                            <th scope="col" style="border-top-right-radius: 1rem">
                                                <?php echo e(__('Action')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="small">
                                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $tableItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($item['code']); ?></td>
                                                <td><?php echo e($item['barcode']); ?></td>
                                                <td><?php echo e($item['name']); ?></td>
                                                <td>
                                                    <input type="number"
                                                        wire:model.live="tableItems.<?php echo e($index); ?>.quantity"
                                                        class="form-control" min="1">
                                                </td>
                                                <td>Rp. <?php echo e(number_format($item['price'], 0, ',', '.')); ?></td>
                                                <td>
                                                    <button type="button"
                                                        onclick="handleremoveItem('<?php echo e($index); ?>');"
                                                        class="button-custom-danger btn-sm">Delete</button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->


                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-between mt-4">
                <h5 class="mt-2">Total Quantity : <?php echo e(array_sum(array_column($tableItems, 'quantity'))); ?></h5>
                <button wire:click="savetoTable" class="button-custom-primary"
                    <?php if(!$tableItems): ?> disabled <?php endif; ?>>Save</button>
            </div>

        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
    </div>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script>
        function handleremoveItem(index) {
            Livewire.dispatch('removeItem', {
                index: index
            });
        }

        Livewire.on('refreshDatatable', (params) => {
            setTimeout(() => {
                $(document).ready(function() {
                    $.fn.dataTable.ext.errMode = 'none';
                    new DataTable('#example', {
                        order: [],
                    });
                });
            }, 1000); // 1000 milliseconds = 1 second
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>
<?php /**PATH C:\laragon\www\rybc\resources\views/livewire/pos/it/it-req-out/it-req-out-create.blade.php ENDPATH**/ ?>