<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-bs-theme="">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/android-chrome-192x192.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/android-chrome-512x512.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/apple-touch-icon.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon-16x16.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon-32x32.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon.ico')); ?>" type="image/x-icon">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name')); ?> - Bestari Jaya</title>
    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <!-- Include Bootstrap 5 CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">

    <!-- Include DataTables Bootstrap 5 extension CSS -->
    <link href="<?php echo e(asset('assets/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
</head>

<body>
    <div id="app">
        
        <main class="">
            <?php echo $__env->yieldContent('content'); ?>

            <script src="<?php echo e(asset('assets/js/sweetalert2@11.js')); ?>"></script>

            <?php if (isset($component)) { $__componentOriginal71c6471fa76ce19017edc287b6f4508c = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal71c6471fa76ce19017edc287b6f4508c)): ?>
<?php $component = $__componentOriginal71c6471fa76ce19017edc287b6f4508c; ?>
<?php unset($__componentOriginal71c6471fa76ce19017edc287b6f4508c); ?>
<?php endif; ?>
        </main>
    </div>

    <!-- Include jQuery -->
    <script src="<?php echo e(asset('assets/js/jquery-3.7.0.js')); ?>"></script>

    <!-- Include DataTables core script -->
    <script src="<?php echo e(asset('assets/js/jquery.dataTables.min.js')); ?>"></script>

    <!-- Include DataTables Bootstrap 5 extension script -->
    <script src="<?php echo e(asset('assets/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            var table = $('#example').DataTable();


            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });

        document.addEventListener("DOMContentLoaded", function() {
            const currentTheme = localStorage.getItem('theme') ||
            'light'; // Get the stored theme or default to 'light'
            document.documentElement.setAttribute('data-bs-theme', currentTheme);

            // Set the icon based on the theme
            const themeIcon = document.getElementById('themeIcon');
            if (currentTheme === 'dark') {
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            } else {
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            }
        });

        const toggleThemeButton = document.getElementById('toggleThemeButton');
        toggleThemeButton.addEventListener('click', () => {
            const currentTheme = document.documentElement.getAttribute('data-bs-theme');
            let newTheme = 'light';

            if (currentTheme === 'light') {
                newTheme = 'dark';
                themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
            } else {
                newTheme = 'light';
                themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
            }

            document.documentElement.setAttribute('data-bs-theme', newTheme);
            localStorage.setItem('theme', newTheme); // Store the theme in local storage
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH C:\laragon\www\rybc\resources\views/layouts/header.blade.php ENDPATH**/ ?>