<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <style>
        * {
            font-family: 'Courier New', Courier, monospace;
            font-size: 13px;
        }

        td,
        th,
        tr,
        table {
            border-collapse: collapse;
            padding: 3px;
            font-size: 1em;
        }

        td.qty,
        th.qty {
            width: 30px;
            max-width: 30px;
        }

        td.keterangan,
        th.keterangan {
            width: 100px;
            max-width: 100px;
            word-break: break-all;
        }

        td.harga,
        th.harga {
            width: 80px;
            max-width: 80px;
            word-break: break-all;
        }

        td.jumlah,
        th.jumlah {
            width: 90px;
            max-width: 90px;
            word-break: break-all;
        }

        .centered {
            text-align: center;
            align-content: center;
        }

        .align-right {
            text-align: right;
        }

        .container {
            width: 76.2mm;
            max-width: 76.2mm;
        }

        .font {
            font-size: 1.2em;
            font-weight: bold;
        }

        .font-isi {
            font-size: 1em;
            font-weight: bold;
        }

        .flex {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            margin-right: 4%;
            margin-left: 2%;
            margin-top: 3%;
        }

        .size {
            font-size: 1.2em;
        }

        @media print {

            @page {
                size: 3in auto;
                /* Set the page width to 3 inches and height to auto */
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
                box-shadow: none;
            }
        }
    </style>
    <title> {{ env('APP_NAME') }} || {{ $invoice->no }}</title>
</head>

<body>
    <div class="container">
        {{-- <p class="centered font">Palm Lagoon TRANS STUDIO BALI</p> --}}
        <p class="centered" style="font-size: 1em;">{{ $setting->wh_name }}<br>Telp: {{ $setting->phone }} <br>{{ $setting->address }}</p>
        {{-- <p class="centered font">Invoice: 123123</p> --}}
        {{-- <p class="centered size">123</p> --}}
        <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>

        <div class="flex">
            @php
                $cashierName = $invoice->users_name;
                $atPosition = strpos($cashierName, '@');
                if ($atPosition !== false) {
                    $cashierName = substr($cashierName, 0, $atPosition);
                }
            @endphp
            <div>Cashier : {{ $cashierName }}

            </div>
        </div>
        <div class="flex" style="margin-top: 2px;">
            <div>Bill No : {{ $invoice->no }}</div>
        </div>
        <div class="flex" style="margin-top: 2px; margin-bottom:10px;">
            <div>Date&nbsp; &nbsp; : {{ \Carbon\Carbon::parse($invoice->created_at)->format('d/m/Y H:i:s') }}</div>
        </div>
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <table style="margin-top:10px; width:100%;">
            <thead>
                <tr style="border-bottom: 1px dashed rgb(0, 0, 0);">
                    <td class="keterangan" style="text-align: left;">Item</td>
                    <td class="qty centered">Qty</td>
                    <td class="harga centered">Price</td>
                </tr>
            </thead>
            <tbody>
                @foreach ($detail as $dt)
                    <tr style="font-size: 0.75em;">
                        <td class="keteranga size">{{ $dt->name }}</td>
                        <td class="qty centered size">

                            {{ intval($dt->qty) }}

                        </td>
                        <td class="harga centered size">
                            {{ number_format($dt->nprice, 0, ',', '.') }}
                            @if ($dt->price != $dt->nprice)
                                <br>({{ number_format($dt->nprice - $dt->price, 0, ',', '.') }})
                            @endif

                        </td>
                    </tr>
                @endforeach

            </tbody>
        </table>
        @if ($invoice->payment == 'Multi' || $invoice->payment == 'Card')
            @php
                $note = json_decode($invoice->note, true);
            @endphp
            <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>
            <div class="flex" style="margin-top: 10px;">
                <div>Card Number : {{ $note['nomor_kartu'] }}</div>
            </div>
            <div class="flex" style="margin-top: 2px; margin-bottom:10px;">
                <div>Name&nbsp; &nbsp; &nbsp; &nbsp; : {{ $note['nama_pemegang_kartu'] }}</div>
            </div>
            <div style="border-bottom: 1px dashed rgb(0, 0, 0); margin-top:10px;"></div>
        @endif
        <div>
            <div style="margin-left: 90px;" class="flex">
                <div>Sub Total &nbsp;: </div>
                <div>{{ number_format($invoice->subtotal, 0, ',', '.') }}</div>
            </div>
            <div style="margin-left: 90px; margin-top:1px;" class="flex">
                <div>Discount &nbsp;&nbsp;:</div>
                <div>{{ number_format($invoice->disc_total, 0, ',', '.') }}</div>
            </div>
            <div style="margin-left: 90px; margin-top:1px;" class="flex">
                <div>GrandTotal :</div>
                <div>{{ number_format($invoice->must_paid, 0, ',', '.') }}</div>
            </div>
            @if ($invoice->payment == 'Multi' || $invoice->payment == 'Card')
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Card &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div>{{ number_format($note['transfer'], 0, ',', '.') }}</div>
                </div>
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Cash &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div>{{ number_format($note['cash'] ?? 0, 0, ',', '.') }}</div>
                </div>
            @else
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Card &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div>0</div>
                </div>
                <div style="margin-left: 90px; margin-top:1px;" class="flex">
                    <div>Cash &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:</div>
                    <div>{{ number_format($invoice->paid, 0, ',', '.') }}</div>
                </div>
            @endif
            <div style="margin-left: 90px; margin-top:1px;" class="flex">
                <div>Change &nbsp;&nbsp;&nbsp;&nbsp;:</div>
                <div>{{ number_format($invoice->change, 0, ',', '.') }}</div>
            </div>
        </div>
        <br>
        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <div class="flex" style="margin-top: 10px; margin-bottom:10px;">
            <div>Handled By : {{ $invoice->sales_name }}</div>
        </div>

        <div style="border-bottom: 1px dashed rgb(0, 0, 0);"></div>

        <p class="centered" style="font-size: 1.1em;">
            {!! $footer !!}
        </p>
        <br><br>
        <p style="text-align:center;">( _ _ _ _ _ _ _ _ _ _ _ )</p>
        &nbsp;
        <br>
    </div>
    <script type="text/javascript">
        window.onload = function() {
            window.print();
        };

        var beforePrint = function() {
            console.log('Functionality to run before printing.');
        };

        var afterPrint = function() {
            setTimeout(function() {
                window.close();
            }, 6000); 
        };

        // Listen for print events
        if (window.matchMedia) {
            var mediaQueryList = window.matchMedia('print');
            mediaQueryList.addListener(function(mql) {
                if (mql.matches) {
                    beforePrint();
                } else {
                    afterPrint();
                }
            });
        }

        window.onbeforeprint = beforePrint;
        window.onafterprint = afterPrint;
    </script>

</body>

</html>
