<div wire:ignore.self class="modal fade" id="modalSyncAll" data-bs-backdrop="static" tabindex="-1" aria-labelledby="modalSyncAllLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSyncAllLabel">Sync Invoice</h5>
                @if($isloading)
                <div id="loadingSpinner" class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                @endif
            </div>
            <div class="modal-body">
                <div class="col-auto">
                    <div class="form-check">
                        <input type="checkbox" id="selectAll" class="form-check-input" wire:model.live="isCheckedAll">
                        <label class="form-check-label" for="selectAll">Sync All</label>
                    </div>
                </div>
                @if(!$isCheckedAll)
                <div class="mt-2 mx-2 row align-items-center">
                    <div class="col">
                        <label for="startDate">Select Date</label>
                        <input type="date" class="form-control" id="startDate" wire:model.live="startDate">
                    </div>
                    <div class="mt-4 col-auto">
                        <button class="custom-button1" wire:click="filter">Check</button>
                    </div>
                </div>
                @endif
            </div>
            
            <div class="modal-footer">
                @if($isloading)
                <button type="button" id="closeSyncAll" class="button-custom-danger" data-bs-dismiss="modal" disabled>Close</button>
                <button id="syncButtonAll" type="button" class="custom-button1" wire:click="clickSyncal" disabled>
                    <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    <span id="innerSpan">Loading . . .</span>
                </button>
                @else
                <button type="button" id="closeSyncAll" class="button-custom-danger" data-bs-dismiss="modal">Close</button>
                <button id="syncButtonAll" type="button" class="custom-button1" wire:click="clickSyncal">Sync</button>
                @endif

            </div>
        </div>
    </div>
</div>
<script>
     
     document.addEventListener('livewire:load', function () {
        document.getElementById('syncButtonAll').addEventListener('click', function() {
    this.disabled = true;
    document.getElementById('closeSyncAll').disabled = true; // Disabling closeSync button

});
    });
    document.getElementById('syncButtonAll').addEventListener('click', function() {
    this.disabled = true;
    document.getElementById('closeSyncAll').disabled = true; // Disabling closeSync button

});
</script>
