<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/it_reqout">{{ __('Inv Transfer Request Out') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Detail') }}
                    </li>
                </ol>

                <div>
                        <button wire:click="close" type="button"
                    class="button-custom-secondary btn-sm ml-2">{{ __('Close') }}</button>
                </div>
                
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="card" style="margin-top: -1rem; margin-bottom: 1rem;">
                        <div class="m-2">
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('IT Request Out Detail No. ') }} <span
                                        class="">{{ $no->no }}</span></h6>
                            </div>
                            <div class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary">{{ __('Date : ') }} <span
                                        class="">{{ $no->date }}</span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-1">
                                <h6 class="card-title text-secondary">{{ __('Remark : ') }} <span
                                        class="">{{ $no->comments }}</span></h6>
                            </div>
                            
                        </div>
                       
                    </div>

                        <div class="table-responsive">
                            <table id="table" class="my-table dataTables_wrapper dt-bootstrap5"
                                style="width:100%;">
                                <thead>
                                    <tr>
                                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                        <th scope="col">{{ __('Code') }}</th>
                                        <th scope="col">{{ __('Barcode') }}</th>
                                        <th scope="col">{{ __('Name') }}</th>
                                        <th scope="col">{{ __('Qty') }}</th>
                                        <th scope="col" style="border-top-right-radius: .5rem">{{ __('Qty Send') }}</th>


                                    </tr>
                                </thead>

                                <tbody class="small">
                                    @foreach ($details as $key => $detail)
                                        <tr wire:key="{{ $detail->code }}">
                                            <th scope="col">{{ $key + 1 }}</td>
                                            <td>{{ $detail->code }}</td>
                                            <td>{{ $detail->barcode }}</td>
                                            <td>{{ $detail->name }}</td>
                                            <td>{{ number_format($detail->qty) }}</td>

                                            <td>

                                                    {{ $detail->qty_send }}

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div wire:ignore.self>
                            <table id="table" class="table dataTables_wrapper dt-bootstrap5"
                                style="width:100%; ">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col"></th>
                                        <th scope="col" colspan="4"></th>
                                        <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>
                                    </tr>
                                </thead>

                                <tbody class="small">

                                    <tr>
                                        <td colspan="2">Total</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td colspan="4"></td>
                                        <td style="text-align: right;">
                                            {{ number_format($details->sum('qty'), 0, ',', ',') }}</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        
                </div>
            </div>
        </div>
    </div>


    <livewire:pos.it.itreqin.add-item-req :no="$no" />
    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script> --}}
    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>


</div>
