<div>
    <div wire:ignore.self class="modal fade" id="invoiceModal" tabindex="-1" aria-labelledby="invoiceModalLabel"
        aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="form-group" wire:key="{{ $refreshKey }}">
                        <div x-data="{ isInputGroupVisible: false }">
                            <div class="form-check" @click="isInputGroupVisible = !isInputGroupVisible"
                                data-toggle="tooltip" title="Click to show/hide voucher">
                                <h5 class="modal-title" style="cursor: pointer;">Payment</h5>
                            </div>
                            <div x-show="isInputGroupVisible" class="form-check">
                                <div class="input-group">
                                    <input type="text" class="form-control" wire:model.live="searchvoucher">
                                    <button class="custom-button1" wire:click="applyVoucher">Apply</button>
                                </div>
                                <span class="text-danger">{{ $message }}</span>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-body">
                    <div class="form-group d-flex justify-content-center align-items-center">
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="cashOption" name="paymentOption"
                                    value="cash" wire:model.live="paymentOption">
                                <label class="form-check-label" for="cashOption">Cash</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F1</h4>
                            </div>

                        </div>
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="qrisOption" name="paymentOption"
                                    value="qris" wire:model.live="paymentOption">
                                <label class="form-check-label" for="qrisOption">QRIS</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F2</h4>
                            </div>
                        </div>
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="cardOption" name="paymentOption"
                                    value="card" wire:model.live="paymentOption">
                                <label class="form-check-label" for="cardOption">Card</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F3</h4>
                            </div>
                        </div>
                        <div class="form-check form-check-inline">
                            <div>
                                <input type="radio" class="form-check-input" id="multiOption" name="paymentOption"
                                    value="multi" wire:model.live="paymentOption">
                                <label class="form-check-label" for="multiOption">Multi</label>
                            </div>
                            <div>
                                <h6
                                    style="color: #007bff; border: 1px solid #007bff; border-radius: 5px; margin-top: .3rem; padding: 4px; font-size: 12px; padding-left: 7px">
                                    F4</h4>
                            </div>
                        </div>
                        @error('paymentOption')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <hr>
                    @if ($paymentOption !== 'card' && $paymentOption !== 'multi')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        @if ($paymentOption === 'cash')
                            <div class="form-group">
                                <label for="payment">Payment:</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp.</span>
                                    <input type="text" id="paymentInput" class="form-control"
                                        wire:model.live.debounce.500ms="payment" autofocus>
                                </div>
                            </div>
                            <div class="form-group mt-2">
                                <label class="fs-3" for="change">Change:</label>
                                <span class="fs-3">Rp. </span><span class="fw-bold text-success fs-3"
                                    wire:model="change">{{ number_format($change, 0, ',', '.') }}</span>
                            </div>
                        @endif
                    @endif
                    @if ($paymentOption === 'card')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="namaBank">Nama Bank</label>
                            <div class="input-group">
                                <select class="input-group-text" id="type" wire:model.live="type">
                                    <option value="Credit">Credit</option>
                                    <option value="Debit">Debit</option>
                                </select>
                                <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                    <option value="BCA">BCA (Bank Central Asia)</option>
                                    <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                    <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                    <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaPemegangKartu">Nama Pemegang Kartu</label>
                            <input type="text" class="form-control" id="namaPemegangKartu"
                                wire:model.live="namaPemegangKartu">
                        </div>
                        <div class="form-group">
                            <label for="nomorKartu">Nomor Kartu</label>
                            <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                            @error('nomorKartu')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                    @if ($paymentOption === 'multi')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        <div class="form-group mt-2">
                            <label for="cash">Cash : </label>
                            <div class="input-group">
                                <span class="input-group-text">Rp.</span>
                                <input type="text" id="cashInput" class="form-control"
                                    wire:model.live.debounce.500ms="cash">
                            </div>
                            <div class="">
                                <label for="totalAmount">Transfer :</label>
                                <span>Rp. </span><span
                                    class="fw-bold">{{ number_format($transfer, 0, ',', '.') }}</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaBank">Nama Bank</label>
                            <div class="input-group">
                                <select class="input-group-text" id="type" wire:model.live="type">
                                    <option value="Credit">Credit</option>
                                    <option value="Debit">Debit</option>
                                </select>
                                <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                    <option value="BCA">BCA (Bank Central Asia)</option>
                                    <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                    <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                    <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaPemegangKartu">Nama Pemegang Kartu</label>
                            <input type="text" class="form-control" id="namaPemegangKartu"
                                wire:model.live="namaPemegangKartu">
                        </div>
                        <div class="form-group">
                            <label for="nomorKartu">Nomor Kartu</label>
                            <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                            @error('nomorKartu')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                </div>
                <div class="modal-footer">
                    @if ($carts->isNotEmpty() && $selectedSales)
                        @if ($paymentOption === 'cash')
                            <button type="button" class="custom-button1" wire:click="save"
                                {{ $paymentOption === 'cash' && ($payment === '' || $payment == 0) ? 'disabled' : '' }}>Save</button>
                        @elseif ($paymentOption === 'multi')
                            <button type="button" class="custom-button1" wire:click="save"
                                {{ $paymentOption === 'multi' && ($cash === '' || $cash == 0) ? 'disabled' : '' }}>Save</button>
                        @else
                            <button type="button" class="custom-button1" wire:click="save">Save</button>
                        @endif
                    @else
                        <button type="button" class="custom-button1" disabled>Save</button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    // document.addEventListener('DOMContentLoaded', function() {
    //     const paymentInput = document.getElementById('paymentInput');
    //     const totalForPay =
    //         @json($totalAmount); // Assuming $total is the PHP variable holding the total value

    //     // Function to format as Indonesian Rupiah (IDR) style
    //     function formatAsIDR(amount) {
    //         return new Intl.NumberFormat('id-ID', {
    //             minimumFractionDigits: 0,
    //         }).format(amount);
    //     }

    //     function selectInput() {
    //         paymentInput.value = formatAsIDR(totalForPay);
    //     }

    //     selectInput();
    // });

    function updateChangeUI(changeValue) {
        const changeElement = document.querySelector('.change'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    function updateChangeTransfer(changeValue) {
        const changeElement = document.querySelector('.transfer'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    const paymentInput = document.getElementById('paymentInput');
    const cashInput = document.getElementById('cashInput');
    const totalAmountElement = document.getElementById('totalAmount');

    function extractNumericValue(element) {
        if (element) {
            const numericValue = parseFloat(element.textContent.replace(/[^\d]/g, ''));
            return isNaN(numericValue) ? 0 : numericValue;
        }
        return 0;
    }

    const totalAmount = extractNumericValue(totalAmountElement);

    function calculateChange() {
        let inputValue = parseFloat(paymentInput.value.replace(/\./g, ''));

        if (!isNaN(inputValue)) {
            const change = inputValue - totalAmount;
            updateChangeUI(change);
        }
    }

    paymentInput.addEventListener('input', calculateChange);
    calculateChange();

    window.addEventListener('keydown', function(event) {
        if (event.ctrlKey && event.key === 'i') {

            if (@this.modalOpen) {
                var paymentInput = document.getElementById('paymentInput');
                var cashInput = document.getElementById('cashInput');
                if (paymentInput) {
                    paymentInput.focus();
                } else {
                    cashInput.focus();
                }
                console.log('i')
            } else {}
        }

        if (event.ctrlKey && event.key === '1') {
            event.preventDefault();

            if (@this.modalOpen) {
                document.getElementById('namaPemegangKartu').focus();
                console.log('1')
            } else {}
        }
        if (event.ctrlKey && event.key === '2') {
            event.preventDefault();

            if (@this.modalOpen) {
                document.getElementById('nomorKartu').focus();
                console.log('2')
            } else {}
        }

        if (event.key === 'Escape' || event.key === 'Esc') {
            event.preventDefault();

            if (@this.modalOpen) {
                @this.resetPayment();
                $('#invoiceModal').modal('hide');

            } else {
                console.log('uwuusekali');
            }
        }
        if (event.ctrlKey && event.key === 's') {
            event.preventDefault();

            if (@this.modalOpen) {
                if (@this.cashfulfil || @this.paymentfulfil || @this.paymentOption == 'qris' || @this
                    .paymentOption == 'card' || @this.paymentOption == 'multi') {
                    if (@this.selectedSales) {
                        @this.save();
                    } else {
                        console.log('selectedSales is empty');
                    }
                } else {
                    console.log('Neither cashfulfil nor paymentfulfil is true');
                }

            } else {
                console.log('There is error occured');
            }
        }
    });

    Livewire.on('reloadTheInv', () => {
        setTimeout(() => {
            window.location.reload(true);
        }, 5000);
    });

    var rupiah = document.getElementById('paymentInput');
    rupiah.addEventListener('keyup', function(e) {
        // tambahkan 'Rp.' pada saat form di ketik
        // gunakan fungsi formatRupiah() untuk mengubah angka yang di ketik menjadi format angka
        rupiah.value = formatRupiah(this.value);
    });

    /* Fungsi formatRupiah */
    function formatRupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        // tambahkan titik jika yang di input sudah menjadi angka ribuan
        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? +rupiah : '');
    }

    Livewire.on('updatedPaymentOption', () => {
        setTimeout(() => {
            const paymentInput = document.getElementById('paymentInput');
            const cashInput = document.getElementById('cashInput');
            if (paymentInput) {
                paymentInput.addEventListener('keyup', function(e) {
                    this.value = formatRupiah(this.value);
                });
            }

            if (cashInput) {
                cashInput.addEventListener('keyup', function(e) {
                    this.value = formatRupiah(this.value);
                });
            }
        }, 1000);
    });
</script>
