<div>
  <div wire:ignore.self class="modal fade" id="modalChangeInv" tabindex="-1" aria-labelledby="modalChangeInvLabel"
      aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-xl">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title" id="modalChangeInvLabel">Invoice Sandbox</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                  <table class="table table-striped mt-2 table-sm" style="width:100%">
                      <thead>
                          <tr>
                              <th style="text-align: center">Invoice</th>
                              <th style="text-align: center">Tanggal</th>
                              <th style="text-align: center">Jam</th>
                              <th style="text-align: center">User</th>
                              <th style="text-align: center">Staff</th>
                              <th style="text-align: center">Qty</th>
                              <th style="text-align: center">Sub Total</th>
                              <th style="text-align: center">Discount</th>
                              <th style="text-align: center">Grand Total</th>
                              <th style="text-align: center">Cash</th>
                              <th style="text-align: center">Card</th>
                          </tr>
                      </thead>
                      <tbody>


                          @foreach ($invoicesbx as $invoice)
                              <tr wire:key="{{ $invoice->no }}">

                                  <td class="text-center" style="cursor: pointer;"
                                      data-bs-target="#modalChangeInv2{{ $invoice->no }}" data-bs-toggle="modal"
                                      data-bs-dismiss="modal"><a class="button-custom-info badge text-black"
                                          title="Click to see details">{{ $invoice->no }}</a></td>
                                  <td>{{ \Carbon\Carbon::parse($invoice->created_at)->format('d/m/y') }}</td>
                                  <td>{{ \Carbon\Carbon::parse($invoice->created_at)->format('H:i') }}</td>
                                  <td>{{ $invoice->users_name }}</td>
                                  <td>{{ $invoice->sales_name }}</td>
                                  <td>{{ $invoice->total_qty }}</td>
                                  <td>Rp.
                                      {{ number_format(($invoice->subtotal ?? 0) < 0 ? 0 : $invoice->subtotal ?? 0, 0, ',', '.') }}
                                  </td>
                                  <td>Rp. {{ number_format($invoice->disc_total, 0, ',', '.') }}</td>
                                  <td>Rp.
                                      {{ number_format(($invoice->grandtotal ?? 0) < 0 ? 0 : $invoice->grandtotal ?? 0, 0, ',', '.') }}
                                  </td>

                                  @if ($invoice->payment === 'Multi')
                                      <td>Rp. {{ number_format($invoice->cash, 0, ',', '.') }}</td>
                                      <td>Rp. {{ number_format($invoice->transfer, 0, ',', '.') }}</td>
                                  @elseif ($invoice->payment === 'Cash' || $invoice->payment === 'Qris')
                                      <td>Rp. {{ number_format($invoice->subtotal, 0, ',', '.') }}</td>
                                      <td>Rp. 0</td>
                                  @elseif ($invoice->payment === 'Card')
                                      <td>Rp. 0</td>
                                      <td>Rp. {{ number_format($invoice->subtotal, 0, ',', '.') }}</td>
                                  @else
                                      {{-- mz --}}
                                      <td>Rp. 0</td>
                                      <td>Rp. 0</td>
                                  @endif
                              </tr>
                          @endforeach

                      </tbody>
                  </table>
              </div>
          </div>
      </div>
  </div>
  @foreach ($invoicesbx as $invoice)
      <div class="modal fade modal-xl" id="modalChangeInv2{{ $invoice->no }}" aria-hidden="true"
          aria-labelledby="modalChangeInvLabel2" tabindex="-1">
          <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title" id="modalChangeInvLabel2">Detail Invoice - {{ $invoice->no }}</h5>
                      <button class="mx-2 btn button-custom-success badge" data-bs-target="#modalChangeInv"
                          data-bs-toggle="modal" data-bs-dismiss="modal"
                          wire:click="changeStatus('{{ $invoice->no }}')">
                          ✓
                      </button>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                      <button class="custom-button1" data-bs-target="#modalChangeInv" data-bs-toggle="modal"
                          data-bs-dismiss="modal">Back</button>
                      <table class="table table-striped table-sm" style="width:100%">
                          <thead>
                              <tr>
                                  <th style="text-align: center">Invoice</th>
                                  <th style="text-align: center">Tanggal</th>
                                  <th style="text-align: center">Staff</th>
                                  <th style="text-align: center">Member</th>
                                  <th style="text-align: center">Item Code</th>
                                  <th style="text-align: center">Item Barcode</th>
                                  <th style="text-align: center">Item Name</th>
                                  <th style="text-align: center">Qty</th>
                                  <th style="text-align: center">Price</th>
                                  <th style="text-align: center">Disc</th>
                                  <th style="text-align: center">Sub Total</th>
                                  <th style="text-align: center">Status Item</th>
                                  <th style="text-align: center">Action</th>

                              </tr>
                          </thead>
                          <tbody>

                              @foreach ($invoice->details as $invoicedetail)
                                  <tr>
                                      <td>{{ $invoicedetail->invoice }}</td>
                                      <td>{{ \Carbon\Carbon::parse($invoicedetail->created_at)->format('d/m/y') }}
                                      </td>
                                      <td>{{ $invoice->sales_name }}</td>

                                      @if (isset($invoicedetail->id_member))
                                          <td>{{ $invoicedetail->member_name }}</td>
                                      @else
                                          <td> - </td>
                                      @endif
                                      <td>`{{ $invoicedetail->code }}`</td>
                                      <td>`{{ $invoicedetail->item_barcode }}`</td>
                                      <td>{{ $invoicedetail->name }}</td>
                                      <td>{{ $invoicedetail->qty }}</td>
                                      <td>Rp. {{ number_format($invoicedetail->price, 0, ',', '.') }}</td>
                                      <td>Rp.
                                          {{ number_format(($invoicedetail->nprice - $invoicedetail->price) * abs($invoicedetail->qty), 0, ',', '.') }}
                                      </td>
                                      <td>Rp. {{ number_format($invoicedetail->total_price, 0, ',', '.') }}</td>
                                      <td style="text-align: center">
                                          @if ($invoicedetail->sandbox == 'Y')
                                              <a style="cursor: default;"
                                                  class="button-custom-info badge text-black">Sandbox</a>
                                          @else
                                              <a style="cursor: default;"
                                                  class="btn button-custom-success badge text-black">Item</a>
                                          @endif
                                      </td>
                                      <td>
                                          @if ($invoicedetail->sandbox == 'Y')
                                              <a class="button-custom-info badge text-black"
                                                  data-bs-target="#exampleModal{{ $invoicedetail->code }}"
                                                  data-bs-toggle="modal" data-bs-dismiss="modal">Edit</a>
                                          @else
                                              <a style="cursor: default;" class="btn button-custom-success badge text-black">
                                                  - </a>
                                          @endif
                                      </td>

                                  </tr>
                              @endforeach
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>
      </div>
  @endforeach
  @foreach ($invoicesbx as $invoice)
      @foreach ($invoice->details as $invoicedetail)
          <div wire:ignore.self class="modal fade " id="exampleModal{{ $invoicedetail->code }}" tabindex="-1"
              aria-labelledby="exampleModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-dialog-centered">
                  <div class="modal-content">
                      <div class="modal-header">
                          <h5 class="modal-title" id="exampleModalLabel">Edit Item Sandbox</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal"
                              aria-label="Close"></button>
                      </div>
                      <div class="modal-body">
                          <div class="form-group">
                              <div class="form-group">
                                  <label class="mt-1" for="barcode">Item Code Bars</label>
                                  <small class="text-warning d-block mt-1"> Old :
                                      {{ $invoicedetail->barcode }}</small>
                                  <input type="text" wire:model.live="itemcodebars" id="itemcodebars"
                                      class="form-control">
                                  @error('itemcodebars')
                                      <small class="text-danger d-block mt-1"> {{ $message }}</small>
                                  @enderror
                              </div>
                              <label class="mt-1" for="code">Item Code</label>
                              <small class="text-warning d-block mt-1"> Old : {{ $invoicedetail->code }}</small>
                              <input type="text" wire:model.live="itemcode" id="itemcode"
                                  class="form-control">
                              @error('itemcode')
                                  <small class="text-danger d-block mt-1"> {{ $message }}</small>
                              @enderror
                          </div>
                          <div class="form-group">
                              <label class="mt-1" for="name">Item Name</label>
                              <small class="text-warning d-block mt-1"> Old : {{ $invoicedetail->name }}</small>
                              <input type="text" wire:model.live="itemname" id="itemname"
                                  class="form-control">
                              @error('itemname')
                                  <small class="text-danger d-block mt-1"> {{ $message }}</small>
                              @enderror
                          </div>
                          <div class="form-group">
                              <label class="mt-1" for="ItemPrice">Price</label>
                              <small class="text-warning d-block mt-1"> Old : Rp.
                                  {{ number_format($invoicedetail->nprice, 0, ',', '.') }}</small>
                              <input type="text" wire:model.live="itemprice" id="itemprice"
                                  class="form-control">
                              @error('itemprice')
                                  <small class="text-danger d-block mt-1"> {{ $message }}</small>
                              @enderror
                          </div>
                      </div>
                      <div class="modal-footer">
                          <button type="button" class="button-custom-secondary"
                              data-bs-target="#modalChangeInv2{{ $invoice->no }}" data-bs-toggle="modal"
                              data-bs-dismiss="modal">Cancel</button>
                          <button type="button" class="custom-button1"
                              wire:click="changeItemSandbox('{{ $invoice->no }}', '{{ $invoicedetail->code }}')"
                              data-bs-dismiss="modal" @if ($this->isSaveButtonDisabled()) disabled @endif>
                              Save
                          </button>
                      </div>
                  </div>
              </div>
          </div>
      @endforeach
  @endforeach
</div>
