<html>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link type="text/css" rel="stylesheet" href="resources/sheet.css">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/sheet.css') }}">

<div class="ritz grid-container" dir="ltr">
    <table>
        <thead>
            <tr></tr>
        </thead>
        <tbody>
            <td></td>
        </tbody>
    </table>
    <table class="waffle" cellspacing="0" cellpadding="0">
        <thead>
            <tr style="height: 20px">
                <th class="s1"></th>
                <th class="s2" style="font-weight: bold;" dir="ltr">ItemCode</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">CodeBars</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">ItemName</th>
                @if ($udf)
                    @foreach ($field as $fld)
                        <th class="s2" style="font-weight: bold;" dir="ltr">
                            Item {{ Str::after($fld, 'U_IDU_') }}
                        </th>
                    @endforeach
                @endif
                <th class="s2" style="font-weight: bold;" dir="ltr">Price</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Qty</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">SubTotal</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">Discount</th>
                <th class="s2" style="font-weight: bold;" dir="ltr">GrandTotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($invoices as $invoice)
                @php
                    $firstDetail = $invoice->detailInvoices->first();
                    $salesName = $firstDetail ? $firstDetail->sales->name : null;
                @endphp
                <tr style="height: 20px">
                    <td class="s1"></td>
                    <td class="s3" dir="ltr" style="text-align: left; font-weight: bold;" colspan="3">
                        {{ $invoice->no }} - {{ $invoice->created_at }}</td>
                    <td class="s3" dir="ltr" style="text-align: center;" @if ($udf) colspan="{{ count($field) - 2 }}" @else colspan="3" @endif>User : {{ $invoice->user->name }}</td>
                    <td class="s5" dir="ltr" style="text-align: center;" @if ($udf) colspan="{{ count($field) - 2 }}" @else colspan="2" @endif>Staff : {{ $salesName }}</td>
                </tr>
                @forelse ($invoice->detailInvoices as $detail)
                    <tr style="height: 20px">
                        <td class="s1"></td>
                        <td class="s4" dir="ltr">{{ $detail->code }}</td>
                        <td class="s4" dir="ltr">{{ optional($detail->item)->barcode }}</td>
                        <td class="s4" dir="ltr">{{ $detail->name }}</td>
                        @if ($udf)
                            @foreach ($field as $fld)
                                <td class="s4" dir="ltr">{{ $detail->item->$fld ?? '-' }}</td>
                            @endforeach
                        @endif
                        <td class="s6" dir="ltr">{{ $detail->nprice }}</td>
                        <td class="s7" dir="ltr">{{ $detail->qty }}</td>
                        <td class="s7" dir="ltr">{{ $detail->nprice * $detail->qty }}</td>
                        <td class="s7" dir="ltr">{{ ($detail->nprice - $detail->price) * abs($detail->qty) }}
                        </td>
                        <td class="s8" dir="ltr">{{ $detail->total_price }}</td>
                    </tr>
                @empty
                    -
                @endforelse
                <tr style="height: 20px">
                    <td class="s1"></td>

                    <td class="s9" style="text-align: left; font-weight: bold;" @if ($udf) colspan="{{ count($field) + 4 }}" @else colspan="4" @endif dir="ltr">
                        SubTotal</td>
                    {{-- @if ($udf)
                        @foreach ($field as $fld)
                            <td display="none"></td>
                        @endforeach
                    @endif --}}
                    <td class="s7" style="font-weight: bold;" dir="ltr">
                        {{ $invoice->detailInvoices->sum('qty') }}</td>
                    <td class="s7" style="font-weight: bold;" dir="ltr">
                        {{ $invoice->detailInvoices->sum('nprice') }}</td>
                    <td class="s7" style="font-weight: bold;" dir="ltr">
                        {{ $invoice->detailInvoices->sum('nprice') - $invoice->detailInvoices->sum('price') }}
                    </td>
                    <td class="s8" style="font-weight: bold;" dir="ltr">
                        {{ $invoice->detailInvoices->sum('total_price') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

</html>
