<?php

namespace App\Traits;

use App\Models\ItemTemp;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Schema;

trait GetItemTraits
{
    protected function isConnectionResetError($e)
    {
        return $e instanceof \GuzzleHttp\Exception\RequestException &&
            strpos($e->getMessage(), 'cURL error 56: Recv failure: Connection was reset') !== false;
    }

    protected function reDoFunction($function, $args = [])
    {
        call_user_func_array([$this, $function], $args);
    }

    public function getItem()
    {
        try {
            $this->isloadingitem = true;
            $this->dispatch('refresh');
            $now = Carbon::now()->toDateString();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $url = $setting->url;
            $whscode = $setting->wh_code;
            $id_pricelist = $wh->id_pricelist;
            $member_pricelist = $setting->member;
            if ($member_pricelist != '0') {
                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\", case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
                ]);
            } else {
                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'0' as \"idprice2\",0 \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\" , case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
                ]);
            }
            $respnoninventory = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"code\",a.\"CodeBars\" as \"barcode\",a.\"ItemName\" as \"name\",a.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\", a.\"InvntItem\" as \"inventory\" , a.\"PrchseItem\" as \"purchase\" , a.\"SellItem\" as \"sales\"",
                "From" => "OITM a",
                "Where" => "a.\"InvntItem\"= 'N' group by a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",a.\"ItmsGrpCod\", a.\"InvntItem\", a.\"PrchseItem\", a.\"SellItem\"",
            ]);

            $responseDiscPeriod = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"item_code\", c.\"CardCode\" as \"cardcode\" ,c.\"ListNum\" as \"id_pricelist\",c.\"FromDate\" as \"from_date\",CASE WHEN c.\"ToDate\" is NULL THEN '2999-12-31' ELSE c.\"ToDate\" end as \"to_date\",c.\"LINENUM\" as \"linenum\",c.\"Discount\" as \"disc\",c.\"Price\" as \"disc_price\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\"",
                "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' group by a.\"ItemCode\",c.\"CardCode\", c.\"ListNum\",c.\"FromDate\",c.\"ToDate\",c.\"LINENUM\",c.\"Discount\",c.\"Price\"",
            ]);

            $responseDiscQty = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"item_code\", d.\"CardCode\" as \"cardcode\", c.\"ListNum\" as \"id_pricelist\",d.\"Amount\" as \"qty\",d.\"Discount\" as \"disc\",d.\"Price\" as \"disc_price\",d.\"SPP1LNum\" as \"linenum_period\",d.\"SPP2LNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\" inner join SPP2 d on c.\"ItemCode\"=d.\"ItemCode\" and c.\"LINENUM\"=d.\"SPP1LNum\" ",
                "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' group by a.\"ItemCode\",d.\"CardCode\", c.\"ListNum\",d.\"Amount\",d.\"Discount\",d.\"Price\",d.\"SPP1LNum\",d.\"SPP2LNum\"",
            ]);
            $jsonDataNonInv = $respnoninventory->json();

            if ($response->successful() && $responseDiscPeriod->successful() && $responseDiscQty->successful() && $respnoninventory->successful()) {
                $jsonData = $response->json();
                $jsonDataNonInv = $respnoninventory->json();
                $jsonDataDiscPeriod = $responseDiscPeriod->json();
                $jsonDataDiscQty = $responseDiscQty->json();
                ItemTemp::where('id_user', $userId)->delete();

                if ($jsonData[0]['code'] != '') {
                    if (!empty($jsonData)) {
                        $chunks = array_chunk($jsonData, 1000);

                        foreach ($chunks as $chunk) {
                            $insertData = [];

                            foreach ($chunk as $item) {
                                $insertData[] = [
                                    'code' => $item['code'],
                                    'barcode' => $item['barcode'],
                                    'name' => $item['name'],
                                    'group_code' => $item['group_code'],
                                    'id_user' => $userId,
                                    'idprice1' => $item['idprice1'],
                                    'price1' => $item['price1'],
                                    'idprice2' => $item['idprice2'],
                                    'price2' => $item['price2'],
                                    'inventory' => $item['inventory'],
                                    'sales' => $item['sales'],
                                    'purchase' => $item['purchase'],
                                ];
                            }
                            DB::table('Luv2_item_temp')->insert($insertData);
                        }
                    }

                    if (!empty($jsonDataNonInv)) {
                        if ($jsonDataNonInv[0]['code'] != '') {

                            $chunks = array_chunk($jsonDataNonInv, 1000);

                            foreach ($chunks as $chunk) {
                                $insertDataNonInv = [];

                                foreach ($chunk as $item) {
                                    $insertDataNonInv[] = [
                                        'code' => $item['code'],
                                        'barcode' => $item['barcode'],
                                        'name' => $item['name'],
                                        'group_code' => $item['group_code'],
                                        'id_user' => $userId,
                                        'idprice1' => $item['idprice1'],
                                        'price1' => $item['price1'],
                                        'idprice2' => $item['idprice2'],
                                        'price2' => $item['price2'],
                                        'inventory' => $item['inventory'],
                                        'sales' => $item['sales'],
                                        'purchase' => $item['purchase'],
                                    ];
                                }
                                DB::table('Luv2_item_temp')->insert($insertDataNonInv);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscPeriod)) {
                        if ($jsonDataDiscPeriod[0]['item_code'] != '') {

                            $chunksDiscPeriod = array_chunk($jsonDataDiscPeriod, 1000);

                            foreach ($chunksDiscPeriod as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'from_date' => $item['from_date'],
                                        'to_date' => ($item['to_date'] === '?' || $item['to_date'] === '') ? '29991231' : $item['to_date'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],
                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc')->insert($insertData);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscQty)) {
                        if ($jsonDataDiscQty[0]['item_code'] != '') {

                            $chunksDiscQty = array_chunk($jsonDataDiscQty, 1000);

                            foreach ($chunksDiscQty as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'linenum_period' => $item['linenum_period'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'qty' => $item['qty'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],

                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc_qty')->insert($insertData);
                            }
                        }
                    }
                    #insert item
                    DB::statement("
                    INSERT INTO \"Luv2_item\" (\"code\", \"barcode\", \"name\", \"group_code\", \"inventory\", \"sales\", \"purchase\" ) 
                    SELECT DISTINCT \"code\", \"barcode\", \"name\", \"group_code\", \"inventory\", \"sales\", \"purchase\"
                    FROM \"Luv2_item_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item\" WHERE \"Luv2_item\".\"code\" = \"Luv2_item_temp\".\"code\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "' 
                ");

                    #update item
                    DB::statement("
                    UPDATE \"Luv2_item\"
                    SET \"barcode\"=\"Luv2_item_temp\".\"barcode\",\"name\"=\"Luv2_item_temp\".\"name\",\"group_code\"=\"Luv2_item_temp\".\"group_code\", \"inventory\"=\"Luv2_item_temp\".\"inventory\", \"sales\"=\"Luv2_item_temp\".\"sales\", \"purchase\"=\"Luv2_item_temp\".\"purchase\"
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item\".\"code\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    AND (
                        \"Luv2_item_temp\".\"barcode\"<>\"Luv2_item\".\"barcode\" OR
                        \"Luv2_item_temp\".\"name\"<>\"Luv2_item\".\"name\" OR
                        \"Luv2_item_temp\".\"group_code\"<>\"Luv2_item\".\"group_code\" OR
                        \"Luv2_item_temp\".\"inventory\"<>\"Luv2_item\".\"inventory\" OR
                        \"Luv2_item_temp\".\"sales\"<>\"Luv2_item\".\"sales\" OR
                        \"Luv2_item_temp\".\"purchase\"<>\"Luv2_item\".\"purchase\"
                    );
                ");

                    #insert price1
                    DB::statement("
                    INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                    SELECT DISTINCT \"code\", \"idprice1\", \"price1\"
                    FROM \"Luv2_item_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice1\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                ");

                    #update price1
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist\"
                    SET \"price\"=\"Luv2_item_temp\".\"price1\"
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice1\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    AND \"Luv2_item_temp\".\"price1\"<>\"Luv2_item_pricelist\".\"price\";
                ");

                    if ($member_pricelist != 0) {
                        #insert price2
                        DB::statement("
                        INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                        SELECT DISTINCT \"code\", \"idprice2\", \"price2\"
                        FROM \"Luv2_item_temp\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\") and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice2\" and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    ");

                        #update price2
                        DB::statement("
                        UPDATE \"Luv2_item_pricelist\"
                        SET \"price\"=\"Luv2_item_temp\".\"price2\"
                        FROM \"Luv2_item_temp\"
                        WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice2\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        AND \"Luv2_item_temp\".\"price2\"<>\"Luv2_item_pricelist\".\"price\";
                    ");
                    }


                    #insert disc period
                    DB::statement("
                        INSERT INTO \"Luv2_item_pricelist_disc\" (\"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\")
                        SELECT DISTINCT \"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\"
                        FROM \"Luv2_item_temp_pricelist_disc\"
                        WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item_pricelist_disc\" WHERE \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\") and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                    ");

                    #update disc period
                    DB::statement("
                        UPDATE \"Luv2_item_pricelist_disc\"
                        SET \"from_date\"=\"Luv2_item_temp_pricelist_disc\".\"from_date\",\"to_date\"=\"Luv2_item_temp_pricelist_disc\".\"to_date\",\"disc\"=\"Luv2_item_temp_pricelist_disc\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                        FROM \"Luv2_item_temp_pricelist_disc\"
                        WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                        AND (
                            \"Luv2_item_pricelist_disc\".\"from_date\"<>\"Luv2_item_temp_pricelist_disc\".\"from_date\" OR
                            \"Luv2_item_pricelist_disc\".\"to_date\"<>\"Luv2_item_temp_pricelist_disc\".\"to_date\" OR
                            \"Luv2_item_pricelist_disc\".\"disc\"<>\"Luv2_item_temp_pricelist_disc\".\"disc\" OR
                            \"Luv2_item_pricelist_disc\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                        );
                    ");

                    #delete pricelist
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist_disc\" SET \"deleted\"='Y';
                ");

                    #delete pricelist
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist_disc\"
                    SET \"deleted\"='N'
                    FROM \"Luv2_item_temp_pricelist_disc\"
                    WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "';
                ");
                    #delete pricelist
                    DB::statement("
                    DELETE FROM \"Luv2_item_pricelist_disc\" WHERE \"deleted\"='Y';
                ");


                    #insert disc qty
                    DB::statement("
                    INSERT INTO \"Luv2_item_pricelist_disc_qty\" (\"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\") 
                    SELECT DISTINCT \"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\"
                    FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\") and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "'
                ");

                    #update disc qty
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist_disc_qty\"
                    SET \"qty\"=\"Luv2_item_temp_pricelist_disc_qty\".\"qty\",\"disc\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                    FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' 
                    AND (
                        \"Luv2_item_pricelist_disc_qty\".\"qty\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"qty\" OR
                        \"Luv2_item_pricelist_disc_qty\".\"disc\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc\" OR
                        \"Luv2_item_pricelist_disc_qty\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                    );
                ");

                    #delete pricelist
                    DB::statement("
                UPDATE \"Luv2_item_pricelist_disc_qty\" SET \"deleted\"='Y';
            ");

                    #delete discqty
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist_disc_qty\"
                    SET \"deleted\"='N' 
                    FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' ;
                ");
                    DB::statement("
                DELETE FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"deleted\"='Y';
            ");

                    ItemTemp::where('id_user', $userId)->delete();

                    $this->alert('success', 'Data Item Synchrone succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('finish');
                    $this->dispatch('aftergetSAPTraits');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloadingitem = false;
                    $this->dispatch('aftergetSAPTraits');
                }
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->reDoFunction('getItem');
            } else {
                throw $e;
            }
        }
    }

    public function getItemWithFilter()
    {
        try {
            $this->isloadingitem = true;
            $this->dispatch('refresh');
            $now = Carbon::now()->toDateString();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $url = $setting->url;
            $whscode = $setting->wh_code;
            $id_pricelist = $wh->id_pricelist;
            $member_pricelist = $setting->member;
            if ($member_pricelist != '0') {
                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\", case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
                ]);
            } else {
                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'0' as \"idprice2\",0 \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\" , case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
                ]);
            }
            $respnoninventory = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"code\",a.\"CodeBars\" as \"barcode\",a.\"ItemName\" as \"name\",a.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\", a.\"InvntItem\" as \"inventory\" , a.\"PrchseItem\" as \"purchase\" , a.\"SellItem\" as \"sales\"",
                "From" => "OITM a",
                "Where" => "a.\"InvntItem\"= 'N' group by a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",a.\"ItmsGrpCod\", a.\"InvntItem\", a.\"PrchseItem\", a.\"SellItem\"",
            ]);

            $responseDiscPeriod = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"item_code\", c.\"CardCode\" as \"cardcode\" ,c.\"ListNum\" as \"id_pricelist\",c.\"FromDate\" as \"from_date\",CASE WHEN c.\"ToDate\" is NULL THEN '2999-12-31' ELSE c.\"ToDate\" end as \"to_date\",c.\"LINENUM\" as \"linenum\",c.\"Discount\" as \"disc\",c.\"Price\" as \"disc_price\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\"",
                "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",c.\"CardCode\", c.\"ListNum\",c.\"FromDate\",c.\"ToDate\",c.\"LINENUM\",c.\"Discount\",c.\"Price\"",
            ]);

            $responseDiscQty = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"item_code\", d.\"CardCode\" as \"cardcode\", c.\"ListNum\" as \"id_pricelist\",d.\"Amount\" as \"qty\",d.\"Discount\" as \"disc\",d.\"Price\" as \"disc_price\",d.\"SPP1LNum\" as \"linenum_period\",d.\"SPP2LNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\" inner join SPP2 d on c.\"ItemCode\"=d.\"ItemCode\" and c.\"LINENUM\"=d.\"SPP1LNum\" ",
                "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",d.\"CardCode\", c.\"ListNum\",d.\"Amount\",d.\"Discount\",d.\"Price\",d.\"SPP1LNum\",d.\"SPP2LNum\"",
            ]);

            if ($response->successful() && $responseDiscPeriod->successful() && $responseDiscQty->successful() && $respnoninventory->successful()) {
                $jsonData = $response->json();
                $jsonDataNonInv = $respnoninventory->json();
                $jsonDataDiscPeriod = $responseDiscPeriod->json();
                $jsonDataDiscQty = $responseDiscQty->json();
                ItemTemp::where('id_user', $userId)->delete();

                if ($jsonData[0]['code'] != '') {
                    if (!empty($jsonData)) {
                        $chunks = array_chunk($jsonData, 1000);

                        foreach ($chunks as $chunk) {
                            $insertData = [];

                            foreach ($chunk as $item) {
                                $insertData[] = [
                                    'code' => $item['code'],
                                    'barcode' => $item['barcode'],
                                    'name' => $item['name'],
                                    'group_code' => $item['group_code'],
                                    'id_user' => $userId,
                                    'idprice1' => $item['idprice1'],
                                    'price1' => $item['price1'],
                                    'idprice2' => $item['idprice2'],
                                    'price2' => $item['price2'],
                                    'inventory' => $item['inventory'],
                                    'sales' => $item['sales'],
                                    'purchase' => $item['purchase'],
                                ];
                            }
                            DB::table('Luv2_item_temp')->insert($insertData);
                        }
                    }

                    if (!empty($jsonDataNonInv)) {
                        if ($jsonDataNonInv[0]['code'] != '') {


                            $chunks = array_chunk($jsonDataNonInv, 1000);

                            foreach ($chunks as $chunk) {
                                $insertDataNonInv = [];

                                foreach ($chunk as $item) {
                                    $insertDataNonInv[] = [
                                        'code' => $item['code'],
                                        'barcode' => $item['barcode'],
                                        'name' => $item['name'],
                                        'group_code' => $item['group_code'],
                                        'id_user' => $userId,
                                        'idprice1' => $item['idprice1'],
                                        'price1' => $item['price1'],
                                        'idprice2' => $item['idprice2'],
                                        'price2' => $item['price2'],
                                        'inventory' => $item['inventory'],
                                        'sales' => $item['sales'],
                                        'purchase' => $item['purchase'],
                                    ];
                                }
                                DB::table('Luv2_item_temp')->insert($insertDataNonInv);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscPeriod)) {
                        if ($jsonDataDiscPeriod[0]['item_code'] != '') {
                            $chunksDiscPeriod = array_chunk($jsonDataDiscPeriod, 1000);

                            foreach ($chunksDiscPeriod as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'from_date' => $item['from_date'],
                                        'to_date' => ($item['to_date'] === '?' || $item['to_date'] === '') ? '29991231' : $item['to_date'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],
                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc')->insert($insertData);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscQty)) {
                        if ($jsonDataDiscQty[0]['item_code'] != '') {

                            $chunksDiscQty = array_chunk($jsonDataDiscQty, 1000);

                            foreach ($chunksDiscQty as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'linenum_period' => $item['linenum_period'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'qty' => $item['qty'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],

                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc_qty')->insert($insertData);
                            }
                        }
                    }
                    #insert item
                    DB::statement("
                        INSERT INTO \"Luv2_item\" (\"code\", \"barcode\", \"name\", \"group_code\", \"inventory\", \"sales\", \"purchase\" ) 
                        SELECT DISTINCT \"code\", \"barcode\", \"name\", \"group_code\", \"inventory\", \"sales\", \"purchase\"
                        FROM \"Luv2_item_temp\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item\" WHERE \"Luv2_item\".\"code\" = \"Luv2_item_temp\".\"code\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    ");

                    #update item
                    DB::statement("
                        UPDATE \"Luv2_item\"
                        SET \"barcode\"=\"Luv2_item_temp\".\"barcode\",\"name\"=\"Luv2_item_temp\".\"name\",\"group_code\"=\"Luv2_item_temp\".\"group_code\", \"inventory\"=\"Luv2_item_temp\".\"inventory\", \"sales\"=\"Luv2_item_temp\".\"sales\", \"purchase\"=\"Luv2_item_temp\".\"purchase\"
                        FROM \"Luv2_item_temp\"
                        WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item\".\"code\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        AND (
                            \"Luv2_item_temp\".\"barcode\"<>\"Luv2_item\".\"barcode\" OR
                            \"Luv2_item_temp\".\"name\"<>\"Luv2_item\".\"name\" OR
                            \"Luv2_item_temp\".\"group_code\"<>\"Luv2_item\".\"group_code\" OR
                            \"Luv2_item_temp\".\"inventory\"<>\"Luv2_item\".\"inventory\" OR
                            \"Luv2_item_temp\".\"sales\"<>\"Luv2_item\".\"sales\" OR
                            \"Luv2_item_temp\".\"purchase\"<>\"Luv2_item\".\"purchase\"
                        );
                    ");

                    #insert price1
                    DB::statement("
                        INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                        SELECT DISTINCT \"code\", \"idprice1\", \"price1\"
                        FROM \"Luv2_item_temp\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice1\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    ");

                    #update price1
                    DB::statement("
                        UPDATE \"Luv2_item_pricelist\"
                        SET \"price\"=\"Luv2_item_temp\".\"price1\"
                        FROM \"Luv2_item_temp\"
                        WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice1\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        AND \"Luv2_item_temp\".\"price1\"<>\"Luv2_item_pricelist\".\"price\";
                    ");

                    if ($member_pricelist != 0) {
                        #insert price2
                        DB::statement("
                            INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                            SELECT DISTINCT \"code\", \"idprice2\", \"price2\"
                            FROM \"Luv2_item_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice2\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        ");

                        #update price2
                        DB::statement("
                            UPDATE \"Luv2_item_pricelist\"
                            SET \"price\"=\"Luv2_item_temp\".\"price2\"
                            FROM \"Luv2_item_temp\"
                            WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice2\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                            AND \"Luv2_item_temp\".\"price2\"<>\"Luv2_item_pricelist\".\"price\";
                        ");
                    }


                    #insert disc period
                    DB::statement("
                            INSERT INTO \"Luv2_item_pricelist_disc\" (\"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\")
                            SELECT DISTINCT \"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\"
                            FROM \"Luv2_item_temp_pricelist_disc\"
                            WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist_disc\" WHERE \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\") and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                        ");

                    #update disc period
                    DB::statement("
                            UPDATE \"Luv2_item_pricelist_disc\"
                            SET \"from_date\"=\"Luv2_item_temp_pricelist_disc\".\"from_date\",\"to_date\"=\"Luv2_item_temp_pricelist_disc\".\"to_date\",\"disc\"=\"Luv2_item_temp_pricelist_disc\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                            FROM \"Luv2_item_temp_pricelist_disc\"
                            WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                            AND (
                                \"Luv2_item_pricelist_disc\".\"from_date\"<>\"Luv2_item_temp_pricelist_disc\".\"from_date\" OR
                                \"Luv2_item_pricelist_disc\".\"to_date\"<>\"Luv2_item_temp_pricelist_disc\".\"to_date\" OR
                                \"Luv2_item_pricelist_disc\".\"disc\"<>\"Luv2_item_temp_pricelist_disc\".\"disc\" OR
                                \"Luv2_item_pricelist_disc\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                            );
                        ");

                    // #delete pricelist
                    // DB::statement("
                    //     UPDATE \"Luv2_item_pricelist_disc\" SET \"deleted\"='Y';
                    // ");

                    // #delete pricelist
                    // DB::statement("
                    //     UPDATE \"Luv2_item_pricelist_disc\"
                    //     SET \"deleted\"='N'
                    //     FROM \"Luv2_item_temp_pricelist_disc\"
                    //     WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "';
                    // ");
                    // #delete pricelist
                    // DB::statement("
                    //     DELETE FROM \"Luv2_item_pricelist_disc\" WHERE \"deleted\"='Y';
                    // ");

                    #insert disc qty
                    DB::statement("
                        INSERT INTO \"Luv2_item_pricelist_disc_qty\" (\"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\") 
                        SELECT DISTINCT \"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\"
                        FROM \"Luv2_item_temp_pricelist_disc_qty\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\") and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "'
                    ");

                    #update disc qty
                    DB::statement("
                        UPDATE \"Luv2_item_pricelist_disc_qty\"
                        SET \"qty\"=\"Luv2_item_temp_pricelist_disc_qty\".\"qty\",\"disc\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                        FROM \"Luv2_item_temp_pricelist_disc_qty\"
                        WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' 
                        AND (
                            \"Luv2_item_pricelist_disc_qty\".\"qty\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"qty\" OR
                            \"Luv2_item_pricelist_disc_qty\".\"disc\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc\" OR
                            \"Luv2_item_pricelist_disc_qty\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                        );
                    ");

                    //     #delete pricelist
                    //     DB::statement("
                    //     UPDATE \"Luv2_item_pricelist_disc_qty\" SET \"deleted\"='Y';
                    // ");

                    //     #delete discqty
                    //     DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc_qty\"
                    //         SET \"deleted\"='N' 
                    //         FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    //         WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' ;
                    //     ");
                    //     DB::statement("
                    //     DELETE FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"deleted\"='Y';
                    // ");

                    ItemTemp::where('id_user', $userId)->delete();

                    $this->alert('success', 'Data Item Synchrone succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('finish');
                    $this->dispatch('aftergetSAPTraits');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloadingitem = false;
                    $this->dispatch('aftergetSAPTraits');
                }
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                // Do something or re-do the function
                $this->reDoFunction('getItemWithFilter');
            } else {
                // Handle other errors
                throw $e; // Re-throw the error
            }
        }
    }

    public function getItemWhereDocnum()
    {
        try {
            $this->isloadingitem = true;
            $this->dispatch('refresh');
            $now = Carbon::now()->toDateString();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $url = $setting->url;
            $whscode = $setting->wh_code;
            $id_pricelist = $wh->id_pricelist;
            $member_pricelist = $setting->member;
            if ($member_pricelist != '0') {
                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\", case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and a.\"BASE_REF\" = '" . $this->docNum . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
                ]);
            } else {
                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'0' as \"idprice2\",0 \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\" , case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and a.\"BASE_REF\" = '" . $this->docNum . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
                ]);
            }
            $respnoninventory = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"code\",a.\"CodeBars\" as \"barcode\",a.\"ItemName\" as \"name\",a.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\", a.\"InvntItem\" as \"inventory\" , a.\"PrchseItem\" as \"purchase\" , a.\"SellItem\" as \"sales\"",
                "From" => "OITM a",
                "Where" => "a.\"InvntItem\"= 'N' group by a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",a.\"ItmsGrpCod\", a.\"InvntItem\", a.\"PrchseItem\", a.\"SellItem\"",
            ]);

            $responseDiscPeriod = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"item_code\", c.\"CardCode\" as \"cardcode\" ,c.\"ListNum\" as \"id_pricelist\",c.\"FromDate\" as \"from_date\",CASE WHEN c.\"ToDate\" is NULL THEN '2999-12-31' ELSE c.\"ToDate\" end as \"to_date\",c.\"LINENUM\" as \"linenum\",c.\"Discount\" as \"disc\",c.\"Price\" as \"disc_price\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\"",
                "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\BASE_REF\" = '" . $this->docNum . "' and a.\"TransType\" = '67' group by a.\"ItemCode\",c.\"CardCode\", c.\"ListNum\",c.\"FromDate\",c.\"ToDate\",c.\"LINENUM\",c.\"Discount\",c.\"Price\"",
            ]);

            $responseDiscQty = Http::post($url . '/api/search', [
                "Select" => "a.\"ItemCode\" as \"item_code\", d.\"CardCode\" as \"cardcode\", c.\"ListNum\" as \"id_pricelist\",d.\"Amount\" as \"qty\",d.\"Discount\" as \"disc\",d.\"Price\" as \"disc_price\",d.\"SPP1LNum\" as \"linenum_period\",d.\"SPP2LNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\" inner join SPP2 d on c.\"ItemCode\"=d.\"ItemCode\" and c.\"LINENUM\"=d.\"SPP1LNum\" ",
                "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\"BASE_REF\" = '" . $this->docNum . "' and a.\"TransType\" = '67' group by a.\"ItemCode\",d.\"CardCode\", c.\"ListNum\",d.\"Amount\",d.\"Discount\",d.\"Price\",d.\"SPP1LNum\",d.\"SPP2LNum\"",
            ]);

            if ($response->successful() && $responseDiscPeriod->successful() && $responseDiscQty->successful() && $respnoninventory->successful()) {
                $jsonData = $response->json();
                $jsonDataNonInv = $respnoninventory->json();
                $jsonDataDiscPeriod = $responseDiscPeriod->json();
                $jsonDataDiscQty = $responseDiscQty->json();
                ItemTemp::where('id_user', $userId)->delete();

                if ($jsonData[0]['code'] != '') {
                    if (!empty($jsonData)) {
                        $chunks = array_chunk($jsonData, 1000);

                        foreach ($chunks as $chunk) {
                            $insertData = [];

                            foreach ($chunk as $item) {
                                $insertData[] = [
                                    'code' => $item['code'],
                                    'barcode' => $item['barcode'],
                                    'name' => $item['name'],
                                    'group_code' => $item['group_code'],
                                    'id_user' => $userId,
                                    'idprice1' => $item['idprice1'],
                                    'price1' => $item['price1'],
                                    'idprice2' => $item['idprice2'],
                                    'price2' => $item['price2'],
                                    'inventory' => $item['inventory'],
                                    'sales' => $item['sales'],
                                    'purchase' => $item['purchase'],
                                ];
                            }
                            DB::table('Luv2_item_temp')->insert($insertData);
                        }
                    }

                    if (!empty($jsonDataNonInv)) {
                        if ($jsonDataNonInv[0]['code'] != '') {

                            $chunks = array_chunk($jsonDataNonInv, 1000);

                            foreach ($chunks as $chunk) {
                                $insertDataNonInv = [];

                                foreach ($chunk as $item) {
                                    $insertDataNonInv[] = [
                                        'code' => $item['code'],
                                        'barcode' => $item['barcode'],
                                        'name' => $item['name'],
                                        'group_code' => $item['group_code'],
                                        'id_user' => $userId,
                                        'idprice1' => $item['idprice1'],
                                        'price1' => $item['price1'],
                                        'idprice2' => $item['idprice2'],
                                        'price2' => $item['price2'],
                                        'inventory' => $item['inventory'],
                                        'sales' => $item['sales'],
                                        'purchase' => $item['purchase'],
                                    ];
                                }
                                DB::table('Luv2_item_temp')->insert($insertDataNonInv);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscPeriod)) {
                        if ($jsonDataDiscPeriod[0]['item_code'] != '') {
                            $chunksDiscPeriod = array_chunk($jsonDataDiscPeriod, 1000);

                            foreach ($chunksDiscPeriod as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'from_date' => $item['from_date'],
                                        'to_date' => ($item['to_date'] === '?' || $item['to_date'] === '') ? '29991231' : $item['to_date'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],
                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc')->insert($insertData);
                            }
                        }
                    }
                    if (!empty($jsonDataDiscQty)) {
                        if ($jsonDataDiscQty[0]['item_code'] != '') {

                            $chunksDiscQty = array_chunk($jsonDataDiscQty, 1000);

                            foreach ($chunksDiscQty as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'linenum_period' => $item['linenum_period'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'qty' => $item['qty'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],

                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc_qty')->insert($insertData);
                            }
                        }
                    }
                    #insert item
                    DB::statement("
                    INSERT INTO \"Luv2_item\" (\"code\", \"barcode\", \"name\", \"group_code\", \"inventory\", \"sales\", \"purchase\" ) 
                    SELECT DISTINCT \"code\", \"barcode\", \"name\", \"group_code\", \"inventory\", \"sales\", \"purchase\"
                    FROM \"Luv2_item_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item\" WHERE \"Luv2_item\".\"code\" = \"Luv2_item_temp\".\"code\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "' 
                ");

                    #update item
                    DB::statement("
                    UPDATE \"Luv2_item\"
                    SET \"barcode\"=\"Luv2_item_temp\".\"barcode\",\"name\"=\"Luv2_item_temp\".\"name\",\"group_code\"=\"Luv2_item_temp\".\"group_code\", \"inventory\"=\"Luv2_item_temp\".\"inventory\", \"sales\"=\"Luv2_item_temp\".\"sales\", \"purchase\"=\"Luv2_item_temp\".\"purchase\"
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item\".\"code\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    AND (
                        \"Luv2_item_temp\".\"barcode\"<>\"Luv2_item\".\"barcode\" OR
                        \"Luv2_item_temp\".\"name\"<>\"Luv2_item\".\"name\" OR
                        \"Luv2_item_temp\".\"group_code\"<>\"Luv2_item\".\"group_code\" OR
                        \"Luv2_item_temp\".\"inventory\"<>\"Luv2_item\".\"inventory\" OR
                        \"Luv2_item_temp\".\"sales\"<>\"Luv2_item\".\"sales\" OR
                        \"Luv2_item_temp\".\"purchase\"<>\"Luv2_item\".\"purchase\"
                    );
                ");

                    #insert price1
                    DB::statement("
                    INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                    SELECT DISTINCT \"code\", \"idprice1\", \"price1\"
                    FROM \"Luv2_item_temp\"
                    WHERE NOT EXISTS (
                        SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice1\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                ");

                    #update price1
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist\"
                    SET \"price\"=\"Luv2_item_temp\".\"price1\"
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice1\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    AND \"Luv2_item_temp\".\"price1\"<>\"Luv2_item_pricelist\".\"price\";
                ");

                    if ($member_pricelist != 0) {
                        #insert price2
                        DB::statement("
                            INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                            SELECT DISTINCT \"code\", \"idprice2\", \"price2\"
                            FROM \"Luv2_item_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice2\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        ");

                        #update price2
                        DB::statement("
                            UPDATE \"Luv2_item_pricelist\"
                            SET \"price\"=\"Luv2_item_temp\".\"price2\"
                            FROM \"Luv2_item_temp\"
                            WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice2\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                            AND \"Luv2_item_temp\".\"price2\"<>\"Luv2_item_pricelist\".\"price\";
                        ");
                    }


                    #insert disc period
                    DB::statement("
                                INSERT INTO \"Luv2_item_pricelist_disc\" (\"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\")
                                SELECT DISTINCT \"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\"
                                FROM \"Luv2_item_temp_pricelist_disc\"
                                WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_pricelist_disc\" WHERE \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\") and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                            ");

                    #update disc period
                    DB::statement("
                                UPDATE \"Luv2_item_pricelist_disc\"
                                SET \"from_date\"=\"Luv2_item_temp_pricelist_disc\".\"from_date\",\"to_date\"=\"Luv2_item_temp_pricelist_disc\".\"to_date\",\"disc\"=\"Luv2_item_temp_pricelist_disc\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                                FROM \"Luv2_item_temp_pricelist_disc\"
                                WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                                AND (
                                    \"Luv2_item_pricelist_disc\".\"from_date\"<>\"Luv2_item_temp_pricelist_disc\".\"from_date\" OR
                                    \"Luv2_item_pricelist_disc\".\"to_date\"<>\"Luv2_item_temp_pricelist_disc\".\"to_date\" OR
                                    \"Luv2_item_pricelist_disc\".\"disc\"<>\"Luv2_item_temp_pricelist_disc\".\"disc\" OR
                                    \"Luv2_item_pricelist_disc\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                                );
                            ");

                    #delete pricelist
                    // DB::statement("
                    //             UPDATE \"Luv2_item_pricelist_disc\" SET \"deleted\"='Y';
                    //         ");

                    // #delete pricelist
                    // DB::statement("
                    //             UPDATE \"Luv2_item_pricelist_disc\"
                    //             SET \"deleted\"='N'
                    //             FROM \"Luv2_item_temp_pricelist_disc\"
                    //             WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "';
                    //         ");

                    // #delete pricelist
                    // DB::statement("
                    //             DELETE FROM \"Luv2_item_pricelist_disc\" WHERE \"deleted\"='Y';
                    //         ");


                    #insert disc qty
                    DB::statement("
                                INSERT INTO \"Luv2_item_pricelist_disc_qty\" (\"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\") 
                                SELECT DISTINCT \"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\"
                                FROM \"Luv2_item_temp_pricelist_disc_qty\"
                                WHERE NOT EXISTS (
                                    SELECT 1 FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\") and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "'
                            ");

                    #update disc qty
                    DB::statement("
                                UPDATE \"Luv2_item_pricelist_disc_qty\"
                                SET \"qty\"=\"Luv2_item_temp_pricelist_disc_qty\".\"qty\",\"disc\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                                FROM \"Luv2_item_temp_pricelist_disc_qty\"
                                WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' 
                                AND (
                                    \"Luv2_item_pricelist_disc_qty\".\"qty\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"qty\" OR
                                    \"Luv2_item_pricelist_disc_qty\".\"disc\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc\" OR
                                    \"Luv2_item_pricelist_disc_qty\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                                );
                            ");

                    // #delete pricelist
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc_qty\" SET \"deleted\"='Y';
                    //     ");

                    // #delete discqty
                    // DB::statement("
                    //             UPDATE \"Luv2_item_pricelist_disc_qty\"
                    //             SET \"deleted\"='N' 
                    //             FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    //             WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' ;
                    //         ");
                    // DB::statement("
                    //         DELETE FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"deleted\"='Y';
                    //     ");

                    ItemTemp::where('id_user', $userId)->delete();

                    $this->alert('success', 'Data Item Synchrone succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('finish');
                    $this->dispatch('aftergetSAPTraits');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloadingitem = false;
                    $this->dispatch('aftergetSAPTraits');
                }
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                // Do something or re-do the function
                $this->reDoFunction('getItemWhereDocnum');
            } else {
                // Handle other errors
                throw $e; // Re-throw the error
            }
        }
    }

    public function getItemwithUDF()
    {
        try {
            $this->isloadingitem = true;
            $this->dispatch('refresh');
            $now = Carbon::now()->toDateString();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $url = $setting->url;
            $urladmin = $setting->url_admin;
            $id_company = $setting->id_company;
            $whscode = $setting->wh_code;
            $id_pricelist = $wh->id_pricelist;
            $member_pricelist = $setting->member;
            $response = Http::get($urladmin . 'udf/' . $id_company);
            $dataudf = $response->json();
            if (!empty($dataudf)) {
                $columnsdefault = ['code', 'barcode', 'name', 'group_code', 'status', 'created_at', 'updated_at', 'id', 'inventory', 'sales', 'purchase', 'active'];
                $columnsdefaulttemp = ['id_user', 'code', 'barcode', 'name', 'group_code', 'status', 'idprice1', 'price1', 'idprice2', 'price2', 'sales', 'purchase', 'inventory'];

                // $columnsnow = Schema::getColumnListing('Luv2_item');

                // $fieldNames = [];
                // foreach ($dataudf as $field) {
                //     if ($field['active'] === 'Y') {
                //         $fieldNames[] = $field['field'];
                //     }
                // }

                // $columnsafterapi = array_merge($columnsdefault, $fieldNames);
                // $columnsToRemove = array_diff($columnsnow, $columnsafterapi);

                // foreach ($columnsToRemove as $columnName) {
                //     Schema::table('Luv2_item', function ($table) use ($columnName) {
                //         $table->dropColumn($columnName);
                //     });

                //     Schema::table('Luv2_item_temp', function ($table) use ($columnName) {
                //         $table->dropColumn($columnName);
                //     });
                // }

                // Get all columns from Luv2_item table
                $columnsLuv2ItemTesting = Schema::getColumnListing('Luv2_item');

                // Get all columns from Luv2_item_temp table
                $columnsLuv2ItemTestingTemp = Schema::getColumnListing('Luv2_item_temp');

                // Identify columns to remove from Luv2_item table
                $columnsToRemoveLuv2ItemTesting = array_diff($columnsLuv2ItemTesting, $columnsdefault);

                // Identify columns to remove from Luv2_item_temp table
                $columnsToRemoveLuv2ItemTestingTemp = array_diff($columnsLuv2ItemTestingTemp, $columnsdefaulttemp);

                // Drop columns from Luv2_item table
                foreach ($columnsToRemoveLuv2ItemTesting as $columnName) {
                    Schema::table('Luv2_item', function ($table) use ($columnName) {
                        $table->dropColumn($columnName);
                    });
                }

                // Drop columns from Luv2_item_temp table
                foreach ($columnsToRemoveLuv2ItemTestingTemp as $columnName) {
                    Schema::table('Luv2_item_temp', function ($table) use ($columnName) {
                        $table->dropColumn($columnName);
                    });
                }

                foreach ($dataudf as $field) {

                    if ($field['active'] === 'Y') {
                        $name = $field['field'];
                        $type = 'string'; //ganti
                        $size = $field['size'];
                        // Check if the column already exists
                        if (!Schema::hasColumn('Luv2_item', $name)) {
                            Schema::table('Luv2_item', function (Blueprint $table) use ($name, $type, $size) {
                                $table->$type($name, $size)->nullable(); // Add the new field to the table
                            });
                        }
                        if (!Schema::hasColumn('Luv2_item_temp', $name)) {
                            Schema::table('Luv2_item_temp', function (Blueprint $table) use ($name, $type, $size) {
                                $table->$type($name, $size)->nullable(); // Add the new field to the table
                            });
                        }
                    }
                }
                if ($member_pricelist != '0') {
                    $fields = [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "c.\"CodeBars\" as \"barcode\"",
                        "name" => "c.\"ItemName\" as \"name\"",
                        "group_code" => "c.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "c.\"InvntItem\" as \"inventory\"",
                        "purchase" => "c.\"PrchseItem\" as \"purchase\"",
                        "sales" => "c.\"SellItem\" as \"sales\"",
                        "active" => "case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    ];
                    $noninv =  [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "a.\"CodeBars\" as \"barcode\"",
                        "name" => "a.\"ItemName\" as \"name\"",
                        "group_code" => "a.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "a.\"InvntItem\" as \"inventory\"",
                        "purchase" => "a.\"PrchseItem\" as \"purchase\"",
                        "sales" => "a.\"SellItem\" as \"sales\"",
                    ];
                } else {
                    $fields = [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "c.\"CodeBars\" as \"barcode\"",
                        "name" => "c.\"ItemName\" as \"name\"",
                        "group_code" => "c.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'0' as \"idprice2\"",
                        "price2" => "0 as \"price2\"",
                        "inventory" => "c.\"InvntItem\" as \"inventory\"",
                        "purchase" => "c.\"PrchseItem\" as \"purchase\"",
                        "sales" => "c.\"SellItem\" as \"sales\"",
                        "active" => "case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    ];
                    $noninv =  [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "a.\"CodeBars\" as \"barcode\"",
                        "name" => "a.\"ItemName\" as \"name\"",
                        "group_code" => "a.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "a.\"InvntItem\" as \"inventory\"",
                        "purchase" => "a.\"PrchseItem\" as \"purchase\"",
                        "sales" => "a.\"SellItem\" as \"sales\"",
                    ];
                }
                $from = "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"";
                $fromnon = "OITM a";
                $where = "a.\"Warehouse\"='" . $whscode . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"";
                $wherenon = "a.\"InvntItem\"= 'N' group by a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",a.\"ItmsGrpCod\", a.\"InvntItem\", a.\"PrchseItem\", a.\"SellItem\"";

                $whereConditions = [];
                $wherenonInvCondition = [];
                foreach ($dataudf as $field) {
                    if ($field['active'] === 'Y') {
                        $fields[$field['field']] = "c.\"" . $field['field'] . "\"";
                        $whereConditions[] = "c.\"" . $field['field'] . "\"";
                        $wherenonInvCondition[] = "a.\"" . $field['field'] . "\"";
                        $noninv[$field['field']] = "a.\"" . $field['field'] . "\"";
                    }
                }

                $select = implode(',', $fields);
                $selectnon = implode(',', $noninv);

                $whereConditionsString = implode(',', $whereConditions);
                $wherenonInvConditionString = implode(',', $wherenonInvCondition);

                // Check if whereConditionsString is not empty before adding it to $where
                if (!empty($whereConditionsString)) {
                    $where .= ", " . $whereConditionsString;
                }

                // Check if wherenonInvConditionString is not empty before adding it to $wherenon
                if (!empty($wherenonInvConditionString)) {
                    $wherenon .= ", " . $wherenonInvConditionString;
                }

                // dd($select, $from, $where, $selectnon, $fromnon, $wherenon);
                $response = Http::post($url . '/api/search', [
                    "Select" => $select,
                    "From" => $from,
                    "Where" => $where,
                ]);

                $respnoninventory = Http::post($url . '/api/search', [
                    "Select" => $selectnon,
                    "From" => $fromnon,
                    "Where" => $wherenon,
                ]);

                $jsonData = $response->json();
                $jsonDataNonInv = $respnoninventory->json();
                $responseDiscPeriod = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"item_code\", c.\"CardCode\" as \"cardcode\" ,c.\"ListNum\" as \"id_pricelist\",c.\"FromDate\" as \"from_date\",CASE WHEN c.\"ToDate\" is NULL THEN '2999-12-31' ELSE c.\"ToDate\" end as \"to_date\",c.\"LINENUM\" as \"linenum\",c.\"Discount\" as \"disc\",c.\"Price\" as \"disc_price\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' group by a.\"ItemCode\",c.\"CardCode\", c.\"ListNum\",c.\"FromDate\",c.\"ToDate\",c.\"LINENUM\",c.\"Discount\",c.\"Price\"",
                ]);

                $responseDiscQty = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"item_code\", d.\"CardCode\" as \"cardcode\", c.\"ListNum\" as \"id_pricelist\",d.\"Amount\" as \"qty\",d.\"Discount\" as \"disc\",d.\"Price\" as \"disc_price\",d.\"SPP1LNum\" as \"linenum_period\",d.\"SPP2LNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\" inner join SPP2 d on c.\"ItemCode\"=d.\"ItemCode\" and c.\"LINENUM\"=d.\"SPP1LNum\" ",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' group by a.\"ItemCode\",d.\"CardCode\", c.\"ListNum\",d.\"Amount\",d.\"Discount\",d.\"Price\",d.\"SPP1LNum\",d.\"SPP2LNum\"",
                ]);

                if ($response->successful() && $responseDiscPeriod->successful() && $responseDiscQty->successful() && $respnoninventory->successful()) {
                    $jsonData = $response->json();
                    $jsonDataNonInv = $respnoninventory->json();
                    $jsonDataDiscPeriod = $responseDiscPeriod->json();
                    $jsonDataDiscQty = $responseDiscQty->json();
                    ItemTemp::where('id_user', $userId)->delete();

                    if ($jsonData[0]['code'] != '') {
                        if (!empty($jsonData)) {
                            $chunks = array_chunk($jsonData, 1000);
                            foreach ($chunks as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertItem = [
                                        'code' => $item['code'],
                                        'barcode' => $item['barcode'],
                                        'name' => $item['name'],
                                        'group_code' => $item['group_code'],
                                        'id_user' => $userId,
                                        'idprice1' => $item['idprice1'],
                                        'price1' => $item['price1'],
                                        'idprice2' => $item['idprice2'],
                                        'price2' => $item['price2'],
                                        'inventory' => $item['inventory'],
                                        'sales' => $item['sales'],
                                        'purchase' => $item['purchase'],
                                    ];

                                    // Add additional fields dynamically
                                    foreach ($dataudf as $field) {
                                        if ($field['active'] === 'Y') {
                                            $fieldName = $field['field'];
                                            $insertItem[$fieldName] = $item[$fieldName] ?? null;
                                        }
                                    }

                                    $insertData[] = $insertItem;
                                }
                                DB::table('Luv2_item_temp')->insert($insertData);
                            }
                        }

                        if (!empty($jsonDataNonInv)) {
                            if ($jsonDataNonInv[0]['code'] != '') {

                                $chunks = array_chunk($jsonDataNonInv, 1000);

                                foreach ($chunks as $chunk) {
                                    $insertDataNonInv = [];

                                    foreach ($chunk as $item) {
                                        $insertItemnonInv = [
                                            'code' => $item['code'],
                                            'barcode' => $item['barcode'],
                                            'name' => $item['name'],
                                            'group_code' => $item['group_code'],
                                            'id_user' => $userId,
                                            'idprice1' => $item['idprice1'],
                                            'price1' => $item['price1'],
                                            'idprice2' => $item['idprice2'],
                                            'price2' => $item['price2'],
                                            'inventory' => $item['inventory'],
                                            'sales' => $item['sales'],
                                            'purchase' => $item['purchase'],
                                        ];

                                        // Add additional fields dynamically
                                        foreach ($dataudf as $field) {
                                            if ($field['active'] === 'Y') {
                                                $fieldName = $field['field'];
                                                $insertItemnonInv[$fieldName] = $item[$fieldName] ?? null;
                                            }
                                        }

                                        $insertDataNonInv[] = $insertItemnonInv;
                                    }
                                }
                                DB::table('Luv2_item_temp')->insert($insertDataNonInv);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscPeriod)) {
                        if ($jsonDataDiscPeriod[0]['item_code'] != '') {

                            $chunksDiscPeriod = array_chunk($jsonDataDiscPeriod, 1000);

                            foreach ($chunksDiscPeriod as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'from_date' => $item['from_date'],
                                        'to_date' => ($item['to_date'] === '?' || $item['to_date'] === '') ? '29991231' : $item['to_date'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],
                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc')->insert($insertData);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscQty)) {
                        if ($jsonDataDiscQty[0]['item_code'] != '') {

                            $chunksDiscQty = array_chunk($jsonDataDiscQty, 1000);

                            foreach ($chunksDiscQty as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'linenum_period' => $item['linenum_period'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'qty' => $item['qty'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],

                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc_qty')->insert($insertData);
                            }
                        }
                    }
                    // Construct the SELECT DISTINCT statement
                    $selectFields = [
                        "\"code\"",
                        "\"barcode\"",
                        "\"name\"",
                        "\"group_code\"",
                        "\"inventory\"",
                        "\"sales\"",
                        "\"purchase\"",
                    ];

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $selectFields[] = "\"{$field['field']}\"";
                        }
                    }

                    $selectStatement = implode(',', $selectFields);

                    // Construct the SQL statement
                    $sqlinsertitem = "
                            INSERT INTO \"Luv2_item\" ($selectStatement) 
                            SELECT DISTINCT $selectStatement
                            FROM \"Luv2_item_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item\" WHERE \"Luv2_item\".\"code\" = \"Luv2_item_temp\".\"code\"
                            ) AND \"Luv2_item_temp\".\"id_user\" = '$userId'
                        ";
                    // Execute the SQL statement
                    DB::statement($sqlinsertitem);
                    $updateFields = [
                        "\"barcode\"=\"Luv2_item_temp\".\"barcode\"",
                        "\"name\"=\"Luv2_item_temp\".\"name\"",
                        "\"group_code\"=\"Luv2_item_temp\".\"group_code\"",
                        "\"inventory\"=\"Luv2_item_temp\".\"inventory\"",
                        "\"sales\"=\"Luv2_item_temp\".\"sales\"",
                        "\"purchase\"=\"Luv2_item_temp\".\"purchase\""
                    ];

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $updateFields[] = "\"$field[field]\"=\"Luv2_item_temp\".\"$field[field]\"";
                        }
                    }

                    $updateFieldsString = implode(', ', $updateFields);

                        $updateQuery = "
                    UPDATE \"Luv2_item\"
                    SET $updateFieldsString
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item\".\"code\" 
                    AND \"Luv2_item_temp\".\"id_user\"='$userId'
                    AND (
                        \"Luv2_item_temp\".\"barcode\"<>\"Luv2_item\".\"barcode\" OR
                        \"Luv2_item_temp\".\"name\"<>\"Luv2_item\".\"name\" OR
                        \"Luv2_item_temp\".\"group_code\"<>\"Luv2_item\".\"group_code\" OR
                        \"Luv2_item_temp\".\"inventory\"<>\"Luv2_item\".\"inventory\" OR
                        \"Luv2_item_temp\".\"sales\"<>\"Luv2_item\".\"sales\" OR
                        \"Luv2_item_temp\".\"purchase\"<>\"Luv2_item\".\"purchase\"";

                        foreach ($dataudf as $field) {
                            if ($field['active'] === 'Y') {
                                $updateQuery .= " OR 
                                \"Luv2_item_temp\".\"$field[field]\"<>\"Luv2_item\".\"$field[field]\" OR \"Luv2_item\".\"$field[field]\" is null";
                            }
                        }

                        $updateQuery .= ");";
                        DB::statement($updateQuery);

                        #insert price1
                        DB::statement("
                        INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                        SELECT DISTINCT \"code\", \"idprice1\", \"price1\"
                        FROM \"Luv2_item_temp\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice1\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    ");

                        #update price1
                        DB::statement("
                        UPDATE \"Luv2_item_pricelist\"
                        SET \"price\"=\"Luv2_item_temp\".\"price1\"
                        FROM \"Luv2_item_temp\"
                        WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice1\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        AND \"Luv2_item_temp\".\"price1\"<>\"Luv2_item_pricelist\".\"price\";
                    ");

                        if ($member_pricelist != 0) {
                            #insert price2
                            DB::statement("
                            INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                            SELECT DISTINCT \"code\", \"idprice2\", \"price2\"
                            FROM \"Luv2_item_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\") and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice2\" and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        ");

                            #update price2
                            DB::statement("
                            UPDATE \"Luv2_item_pricelist\"
                            SET \"price\"=\"Luv2_item_temp\".\"price2\"
                            FROM \"Luv2_item_temp\"
                            WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice2\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                            AND \"Luv2_item_temp\".\"price2\"<>\"Luv2_item_pricelist\".\"price\";
                        ");
                        }


                        #insert disc period
                        DB::statement("
                            INSERT INTO \"Luv2_item_pricelist_disc\" (\"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\")
                            SELECT DISTINCT \"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\"
                            FROM \"Luv2_item_temp_pricelist_disc\"
                            WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist_disc\" WHERE \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\") and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                        ");

                        #update disc period
                        DB::statement("
                            UPDATE \"Luv2_item_pricelist_disc\"
                            SET \"from_date\"=\"Luv2_item_temp_pricelist_disc\".\"from_date\",\"to_date\"=\"Luv2_item_temp_pricelist_disc\".\"to_date\",\"disc\"=\"Luv2_item_temp_pricelist_disc\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                            FROM \"Luv2_item_temp_pricelist_disc\"
                            WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                            AND (
                                \"Luv2_item_pricelist_disc\".\"from_date\"<>\"Luv2_item_temp_pricelist_disc\".\"from_date\" OR
                                \"Luv2_item_pricelist_disc\".\"to_date\"<>\"Luv2_item_temp_pricelist_disc\".\"to_date\" OR
                                \"Luv2_item_pricelist_disc\".\"disc\"<>\"Luv2_item_temp_pricelist_disc\".\"disc\" OR
                                \"Luv2_item_pricelist_disc\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                            );
                        ");

                        #delete pricelist
                        DB::statement("
                        UPDATE \"Luv2_item_pricelist_disc\" SET \"deleted\"='Y';
                    ");

                        #delete pricelist
                        DB::statement("
                        UPDATE \"Luv2_item_pricelist_disc\"
                        SET \"deleted\"='N'
                        FROM \"Luv2_item_temp_pricelist_disc\"
                        WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "';
                    ");
                        #delete pricelist
                        DB::statement("
                        DELETE FROM \"Luv2_item_pricelist_disc\" WHERE \"deleted\"='Y';
                    ");


                        #insert disc qty
                        DB::statement("
                        INSERT INTO \"Luv2_item_pricelist_disc_qty\" (\"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\") 
                        SELECT DISTINCT \"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\"
                        FROM \"Luv2_item_temp_pricelist_disc_qty\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\") and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "'
                    ");

                        #update disc qty
                        DB::statement("
                        UPDATE \"Luv2_item_pricelist_disc_qty\"
                        SET \"qty\"=\"Luv2_item_temp_pricelist_disc_qty\".\"qty\",\"disc\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                        FROM \"Luv2_item_temp_pricelist_disc_qty\"
                        WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' 
                        AND (
                            \"Luv2_item_pricelist_disc_qty\".\"qty\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"qty\" OR
                            \"Luv2_item_pricelist_disc_qty\".\"disc\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc\" OR
                            \"Luv2_item_pricelist_disc_qty\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                        );
                    ");

                        #delete pricelist
                        DB::statement("
                    UPDATE \"Luv2_item_pricelist_disc_qty\" SET \"deleted\"='Y';
                ");

                            #delete discqty
                            DB::statement("
                            UPDATE \"Luv2_item_pricelist_disc_qty\"
                            SET \"deleted\"='N' 
                            FROM \"Luv2_item_temp_pricelist_disc_qty\"
                            WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' ;
                        ");
                            DB::statement("
                        DELETE FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"deleted\"='Y';
                    ");

                        ItemTemp::where('id_user', $userId)->delete();

                        $this->alert('success', 'Data Item Synchrone succesfully', [
                            'position' => 'top-right',
                            'timer' => 3000,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);
                        $this->dispatch('finish');
                        $this->dispatch('aftergetSAPTraits');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloadingitem = false;
                    $this->dispatch('aftergetSAPTraits');
                }
            } else {
                $this->alert('info', 'Theres no data Item', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isloadingitem = false;
                $this->dispatch('aftergetSAPTraits');
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                // Do something or re-do the function
                $this->reDoFunction('getItemwithUDF');
            } else {
                // Handle other errors
                throw $e; // Re-throw the error
            }
        }
    }

    public function getItemwithUDFWhereDocnum()
    {
        try {
            $this->isloadingitem = true;
            $this->dispatch('refresh');
            $now = Carbon::now()->toDateString();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $url = $setting->url;
            $urladmin = $setting->url_admin;
            $id_company = $setting->id_company;
            $whscode = $setting->wh_code;
            $id_pricelist = $wh->id_pricelist;
            $member_pricelist = $setting->member;
            $response = Http::get($urladmin . 'udf/' . $id_company);
            $dataudf = $response->json();
            if (!empty($dataudf)) {
                $columnsdefault = ['code', 'barcode', 'name', 'group_code', 'status', 'created_at', 'updated_at', 'id', 'inventory', 'sales', 'purchase', 'active'];
                $columnsdefaulttemp = ['id_user', 'code', 'barcode', 'name', 'group_code', 'status', 'idprice1', 'price1', 'idprice2', 'price2', 'sales', 'purchase', 'inventory'];

                // $columnsnow = Schema::getColumnListing('Luv2_item');

                // $fieldNames = [];
                // foreach ($dataudf as $field) {
                //     if ($field['active'] === 'Y') {
                //         $fieldNames[] = $field['field'];
                //     }
                // }

                // $columnsafterapi = array_merge($columnsdefault, $fieldNames);
                // $columnsToRemove = array_diff($columnsnow, $columnsafterapi);

                // foreach ($columnsToRemove as $columnName) {
                //     Schema::table('Luv2_item', function ($table) use ($columnName) {
                //         $table->dropColumn($columnName);
                //     });

                //     Schema::table('Luv2_item_temp', function ($table) use ($columnName) {
                //         $table->dropColumn($columnName);
                //     });
                // }

                // Get all columns from Luv2_item table
                $columnsLuv2ItemTesting = Schema::getColumnListing('Luv2_item');

                // Get all columns from Luv2_item_temp table
                $columnsLuv2ItemTestingTemp = Schema::getColumnListing('Luv2_item_temp');

                // Identify columns to remove from Luv2_item table
                $columnsToRemoveLuv2ItemTesting = array_diff($columnsLuv2ItemTesting, $columnsdefault);

                // Identify columns to remove from Luv2_item_temp table
                $columnsToRemoveLuv2ItemTestingTemp = array_diff($columnsLuv2ItemTestingTemp, $columnsdefaulttemp);

                // Drop columns from Luv2_item table
                foreach ($columnsToRemoveLuv2ItemTesting as $columnName) {
                    Schema::table('Luv2_item', function ($table) use ($columnName) {
                        $table->dropColumn($columnName);
                    });
                }

                // Drop columns from Luv2_item_temp table
                foreach ($columnsToRemoveLuv2ItemTestingTemp as $columnName) {
                    Schema::table('Luv2_item_temp', function ($table) use ($columnName) {
                        $table->dropColumn($columnName);
                    });
                }
                foreach ($dataudf as $field) {
                    if ($field['active'] === 'Y') {
                        $name = $field['field'];
                        $type = 'string';
                        $size = $field['size'];
                        // Check if the column already exists
                        if (!Schema::hasColumn('Luv2_item', $name)) {
                            Schema::table('Luv2_item', function (Blueprint $table) use ($name, $type, $size) {
                                $table->$type($name, $size)->nullable(); // Add the new field to the table
                            });
                        }
                        if (!Schema::hasColumn('Luv2_item_temp', $name)) {
                            Schema::table('Luv2_item_temp', function (Blueprint $table) use ($name, $type, $size) {
                                $table->$type($name, $size)->nullable(); // Add the new field to the table
                            });
                        }
                    }
                }
                if ($member_pricelist != '0') {
                    $fields = [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "c.\"CodeBars\" as \"barcode\"",
                        "name" => "c.\"ItemName\" as \"name\"",
                        "group_code" => "c.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "c.\"InvntItem\" as \"inventory\"",
                        "purchase" => "c.\"PrchseItem\" as \"purchase\"",
                        "sales" => "c.\"SellItem\" as \"sales\"",
                        "active" => "case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    ];
                    $noninv =  [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "a.\"CodeBars\" as \"barcode\"",
                        "name" => "a.\"ItemName\" as \"name\"",
                        "group_code" => "a.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "a.\"InvntItem\" as \"inventory\"",
                        "purchase" => "a.\"PrchseItem\" as \"purchase\"",
                        "sales" => "a.\"SellItem\" as \"sales\"",
                    ];
                } else {
                    $fields = [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "c.\"CodeBars\" as \"barcode\"",
                        "name" => "c.\"ItemName\" as \"name\"",
                        "group_code" => "c.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'0' as \"idprice2\"",
                        "price2" => "0 as \"price2\"",
                        "inventory" => "c.\"InvntItem\" as \"inventory\"",
                        "purchase" => "c.\"PrchseItem\" as \"purchase\"",
                        "sales" => "c.\"SellItem\" as \"sales\"",
                        "active" => "case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    ];
                    $noninv =  [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "a.\"CodeBars\" as \"barcode\"",
                        "name" => "a.\"ItemName\" as \"name\"",
                        "group_code" => "a.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "a.\"InvntItem\" as \"inventory\"",
                        "purchase" => "a.\"PrchseItem\" as \"purchase\"",
                        "sales" => "a.\"SellItem\" as \"sales\"",
                    ];
                }
                $from = "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"";
                $fromnon = "OITM a";
                $where = "a.\"Warehouse\"='" . $whscode . "' and a.\"BASE_REF\" = '" . $this->docNum . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"";
                $wherenon = "a.\"InvntItem\"= 'N' group by a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",a.\"ItmsGrpCod\", a.\"InvntItem\", a.\"PrchseItem\", a.\"SellItem\"";

                $whereConditions = [];
                $wherenonInvCondition = [];
                foreach ($dataudf as $field) {
                    if ($field['active'] === 'Y') {
                        $fields[$field['field']] = "c.\"" . $field['field'] . "\"";
                        $whereConditions[] = "c.\"" . $field['field'] . "\"";
                        $wherenonInvCondition[] = "a.\"" . $field['field'] . "\"";
                        $noninv[$field['field']] = "a.\"" . $field['field'] . "\"";
                    }
                }

                $select = implode(',', $fields);
                $selectnon = implode(',', $noninv);

                $whereConditionsString = implode(',', $whereConditions);
                $wherenonInvConditionString = implode(',', $wherenonInvCondition);

                // Check if whereConditionsString is not empty before adding it to $where
                if (!empty($whereConditionsString)) {
                    $where .= ", " . $whereConditionsString;
                }

                // Check if wherenonInvConditionString is not empty before adding it to $wherenon
                if (!empty($wherenonInvConditionString)) {
                    $wherenon .= ", " . $wherenonInvConditionString;
                }

                // dd($select, $from, $where, $selectnon, $fromnon, $wherenon);
                $response = Http::post($url . '/api/search', [
                    "Select" => $select,
                    "From" => $from,
                    "Where" => $where,
                ]);

                $respnoninventory = Http::post($url . '/api/search', [
                    "Select" => $selectnon,
                    "From" => $fromnon,
                    "Where" => $wherenon,
                ]);

                $jsonData = $response->json();
                $jsonDataNonInv = $respnoninventory->json();
                $responseDiscPeriod = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"item_code\", c.\"CardCode\" as \"cardcode\" ,c.\"ListNum\" as \"id_pricelist\",c.\"FromDate\" as \"from_date\",CASE WHEN c.\"ToDate\" is NULL THEN '2999-12-31' ELSE c.\"ToDate\" end as \"to_date\",c.\"LINENUM\" as \"linenum\",c.\"Discount\" as \"disc\",c.\"Price\" as \"disc_price\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\BASE_REF\" = '" . $this->docNum . "' and a.\"TransType\" = '67' group by a.\"ItemCode\",c.\"CardCode\", c.\"ListNum\",c.\"FromDate\",c.\"ToDate\",c.\"LINENUM\",c.\"Discount\",c.\"Price\"",
                ]);

                $responseDiscQty = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"item_code\", d.\"CardCode\" as \"cardcode\", c.\"ListNum\" as \"id_pricelist\",d.\"Amount\" as \"qty\",d.\"Discount\" as \"disc\",d.\"Price\" as \"disc_price\",d.\"SPP1LNum\" as \"linenum_period\",d.\"SPP2LNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\" inner join SPP2 d on c.\"ItemCode\"=d.\"ItemCode\" and c.\"LINENUM\"=d.\"SPP1LNum\" ",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\"BASE_REF\" = '" . $this->docNum . "' and a.\"TransType\" = '67' group by a.\"ItemCode\",d.\"CardCode\", c.\"ListNum\",d.\"Amount\",d.\"Discount\",d.\"Price\",d.\"SPP1LNum\",d.\"SPP2LNum\"",
                ]);


                if ($response->successful() && $responseDiscPeriod->successful() && $responseDiscQty->successful() && $respnoninventory->successful()) {
                    $jsonData = $response->json();
                    $jsonDataNonInv = $respnoninventory->json();
                    $jsonDataDiscPeriod = $responseDiscPeriod->json();
                    $jsonDataDiscQty = $responseDiscQty->json();
                    ItemTemp::where('id_user', $userId)->delete();

                    if ($jsonData[0]['code'] != '') {
                        if (!empty($jsonData)) {
                            $chunks = array_chunk($jsonData, 1000);

                            foreach ($chunks as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertItem = [
                                        'code' => $item['code'],
                                        'barcode' => $item['barcode'],
                                        'name' => $item['name'],
                                        'group_code' => $item['group_code'],
                                        'id_user' => $userId,
                                        'idprice1' => $item['idprice1'],
                                        'price1' => $item['price1'],
                                        'idprice2' => $item['idprice2'],
                                        'price2' => $item['price2'],
                                        'inventory' => $item['inventory'],
                                        'sales' => $item['sales'],
                                        'purchase' => $item['purchase'],
                                    ];

                                    // Add additional fields dynamically
                                    foreach ($dataudf as $field) {
                                        if ($field['active'] === 'Y') {
                                            $fieldName = $field['field'];
                                            $insertItem[$fieldName] = $item[$fieldName] ?? null;
                                        }
                                    }

                                    $insertData[] = $insertItem;
                                }
                                DB::table('Luv2_item_temp')->insert($insertData);
                            }
                        }

                        if (!empty($jsonDataNonInv)) {
                            if ($jsonDataNonInv[0]['code'] != '') {

                                $chunks = array_chunk($jsonDataNonInv, 1000);

                                foreach ($chunks as $chunk) {
                                    $insertDataNonInv = [];

                                    foreach ($chunk as $item) {
                                        $insertItemnonInv = [
                                            'code' => $item['code'],
                                            'barcode' => $item['barcode'],
                                            'name' => $item['name'],
                                            'group_code' => $item['group_code'],
                                            'id_user' => $userId,
                                            'idprice1' => $item['idprice1'],
                                            'price1' => $item['price1'],
                                            'idprice2' => $item['idprice2'],
                                            'price2' => $item['price2'],
                                            'inventory' => $item['inventory'],
                                            'sales' => $item['sales'],
                                            'purchase' => $item['purchase'],
                                        ];

                                        // Add additional fields dynamically
                                        foreach ($dataudf as $field) {
                                            if ($field['active'] === 'Y') {
                                                $fieldName = $field['field'];
                                                $insertItemnonInv[$fieldName] = $item[$fieldName] ?? null;
                                            }
                                        }

                                        $insertDataNonInv[] = $insertItemnonInv;
                                    }
                                }
                                DB::table('Luv2_item_temp')->insert($insertDataNonInv);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscPeriod)) {
                        if ($jsonDataDiscPeriod[0]['item_code'] != '') {

                            $chunksDiscPeriod = array_chunk($jsonDataDiscPeriod, 1000);

                            foreach ($chunksDiscPeriod as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'from_date' => $item['from_date'],
                                        'to_date' => ($item['to_date'] === '?' || $item['to_date'] === '') ? '29991231' : $item['to_date'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],
                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc')->insert($insertData);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscQty)) {
                        if ($jsonDataDiscQty[0]['item_code'] != '') {

                            $chunksDiscQty = array_chunk($jsonDataDiscQty, 1000);

                            foreach ($chunksDiscQty as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'linenum_period' => $item['linenum_period'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'qty' => $item['qty'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],

                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc_qty')->insert($insertData);
                            }
                        }
                    }
                    // Construct the SELECT DISTINCT statement
                    $selectFields = [
                        "\"code\"",
                        "\"barcode\"",
                        "\"name\"",
                        "\"group_code\"",
                        "\"inventory\"",
                        "\"sales\"",
                        "\"purchase\"",
                    ];

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $selectFields[] = "\"{$field['field']}\"";
                        }
                    }

                    $selectStatement = implode(',', $selectFields);
                    // Construct the SQL statement
                    $sqlinsertitem = "
                                INSERT INTO \"Luv2_item\" ($selectStatement) 
                                SELECT DISTINCT $selectStatement
                                FROM \"Luv2_item_temp\"
                                WHERE NOT EXISTS (
                                    SELECT 1 FROM \"Luv2_item\" WHERE \"Luv2_item\".\"code\" = \"Luv2_item_temp\".\"code\"
                                ) AND \"Luv2_item_temp\".\"id_user\" = '$userId'
                            ";

                    // Execute the SQL statement
                    DB::statement($sqlinsertitem);
                    $updateFields = [
                        "\"barcode\"=\"Luv2_item_temp\".\"barcode\"",
                        "\"name\"=\"Luv2_item_temp\".\"name\"",
                        "\"group_code\"=\"Luv2_item_temp\".\"group_code\"",
                        "\"inventory\"=\"Luv2_item_temp\".\"inventory\"",
                        "\"sales\"=\"Luv2_item_temp\".\"sales\"",
                        "\"purchase\"=\"Luv2_item_temp\".\"purchase\""
                    ];

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $updateFields[] = "\"$field[field]\"=\"Luv2_item_temp\".\"$field[field]\"";
                        }
                    }

                    $updateFieldsString = implode(', ', $updateFields);

                    $updateQuery = "
                    UPDATE \"Luv2_item\"
                    SET $updateFieldsString
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item\".\"code\" 
                    AND \"Luv2_item_temp\".\"id_user\"='$userId'
                    AND (
                        \"Luv2_item_temp\".\"barcode\"<>\"Luv2_item\".\"barcode\" OR
                        \"Luv2_item_temp\".\"name\"<>\"Luv2_item\".\"name\" OR
                        \"Luv2_item_temp\".\"group_code\"<>\"Luv2_item\".\"group_code\" OR
                        \"Luv2_item_temp\".\"inventory\"<>\"Luv2_item\".\"inventory\" OR
                        \"Luv2_item_temp\".\"sales\"<>\"Luv2_item\".\"sales\" OR
                        \"Luv2_item_temp\".\"purchase\"<>\"Luv2_item\".\"purchase\"";

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $updateQuery .= " OR 
                            \"Luv2_item_temp\".\"$field[field]\"<>\"Luv2_item\".\"$field[field]\" OR \"Luv2_item\".\"$field[field]\" is null";
                        }
                    }

                    $updateQuery .= ");";

                    DB::statement($updateQuery);

                    #insert price1
                    DB::statement("
                 INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                 SELECT DISTINCT \"code\", \"idprice1\", \"price1\"
                 FROM \"Luv2_item_temp\"
                 WHERE NOT EXISTS (
                     SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice1\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
             ");

                    #update price1
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist\"
                    SET \"price\"=\"Luv2_item_temp\".\"price1\"
                    FROM \"Luv2_item_temp\"
                    WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice1\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    AND \"Luv2_item_temp\".\"price1\"<>\"Luv2_item_pricelist\".\"price\";
                ");

                    if ($member_pricelist != 0) {
                        #insert price2
                        DB::statement("
                        INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                        SELECT DISTINCT \"code\", \"idprice2\", \"price2\"
                        FROM \"Luv2_item_temp\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice2\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                    ");

                        #update price2
                        DB::statement("
                        UPDATE \"Luv2_item_pricelist\"
                        SET \"price\"=\"Luv2_item_temp\".\"price2\"
                        FROM \"Luv2_item_temp\"
                        WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice2\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        AND \"Luv2_item_temp\".\"price2\"<>\"Luv2_item_pricelist\".\"price\";
                    ");
                    }


                    #insert disc period
                    DB::statement("
                INSERT INTO \"Luv2_item_pricelist_disc\" (\"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\")
                SELECT DISTINCT \"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\"
                FROM \"Luv2_item_temp_pricelist_disc\"
                WHERE NOT EXISTS (
                SELECT 1 FROM \"Luv2_item_pricelist_disc\" WHERE \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\") and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
            ");

                    #update disc period
                    DB::statement("
                UPDATE \"Luv2_item_pricelist_disc\"
                SET \"from_date\"=\"Luv2_item_temp_pricelist_disc\".\"from_date\",\"to_date\"=\"Luv2_item_temp_pricelist_disc\".\"to_date\",\"disc\"=\"Luv2_item_temp_pricelist_disc\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                FROM \"Luv2_item_temp_pricelist_disc\"
                WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                AND (
                    \"Luv2_item_pricelist_disc\".\"from_date\"<>\"Luv2_item_temp_pricelist_disc\".\"from_date\" OR
                    \"Luv2_item_pricelist_disc\".\"to_date\"<>\"Luv2_item_temp_pricelist_disc\".\"to_date\" OR
                    \"Luv2_item_pricelist_disc\".\"disc\"<>\"Luv2_item_temp_pricelist_disc\".\"disc\" OR
                    \"Luv2_item_pricelist_disc\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                );
            ");

                    // #delete pricelist
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc\" SET \"deleted\"='Y';
                    //     ");

                    // #delete pricelist
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc\"
                    //         SET \"deleted\"='N'
                    //         FROM \"Luv2_item_temp_pricelist_disc\"
                    //         WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "';
                    //     ");
                    // #delete pricelist
                    // DB::statement("
                    //         DELETE FROM \"Luv2_item_pricelist_disc\" WHERE \"deleted\"='Y';
                    //     ");


                    #insert disc qty
                    DB::statement("
                INSERT INTO \"Luv2_item_pricelist_disc_qty\" (\"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\") 
                SELECT DISTINCT \"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\"
                FROM \"Luv2_item_temp_pricelist_disc_qty\"
                WHERE NOT EXISTS (
                    SELECT 1 FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\") and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "'
            ");

                    #update disc qty
                    DB::statement("
                UPDATE \"Luv2_item_pricelist_disc_qty\"
                SET \"qty\"=\"Luv2_item_temp_pricelist_disc_qty\".\"qty\",\"disc\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                FROM \"Luv2_item_temp_pricelist_disc_qty\"
                WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' 
                AND (
                    \"Luv2_item_pricelist_disc_qty\".\"qty\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"qty\" OR
                    \"Luv2_item_pricelist_disc_qty\".\"disc\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc\" OR
                    \"Luv2_item_pricelist_disc_qty\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                );
            ");

                    // #delete pricelist
                    // DB::statement("
                    //     UPDATE \"Luv2_item_pricelist_disc_qty\" SET \"deleted\"='Y';
                    // ");

                    // #delete discqty
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc_qty\"
                    //         SET \"deleted\"='N' 
                    //         FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    //         WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' ;
                    //     ");
                    // DB::statement("
                    //     DELETE FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"deleted\"='Y';
                    // ");

                    ItemTemp::where('id_user', $userId)->delete();

                    $this->alert('success', 'Data Item Synchrone succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('finish');
                    $this->dispatch('aftergetSAPTraits');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloadingitem = false;
                    $this->dispatch('aftergetSAPTraits');
                }
            } else {
                $this->alert('info', 'Theres no data Item', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isloadingitem = false;
                $this->dispatch('aftergetSAPTraits');
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                // Do something or re-do the function
                $this->reDoFunction('getItemwithUDFWhereDocnum');
            } else {
                // Handle other errors
                throw $e; // Re-throw the error
            }
        }
    }

    public function getItemwithUDFandFilter()
    {
        try {
            $this->isloadingitem = true;
            $this->dispatch('refresh');
            $now = Carbon::now()->toDateString();
            $user = Auth::user();
            $setting = Settings::where('wh_code', $user->whs_code)->first();
            $wh = Warehouse::where('code', $user->whs_code)->first();
            $userId = auth()->user()->id;
            $url = $setting->url;
            $urladmin = $setting->url_admin;
            $id_company = $setting->id_company;
            $whscode = $setting->wh_code;
            $id_pricelist = $wh->id_pricelist;
            $member_pricelist = $setting->member;
            $response = Http::get($urladmin . 'udf/' . $id_company);
            $dataudf = $response->json();
            if (!empty($dataudf)) {
                $columnsdefault = ['code', 'barcode', 'name', 'group_code', 'status', 'created_at', 'updated_at', 'id', 'inventory', 'sales', 'purchase', 'active'];
                $columnsdefaulttemp = ['id_user', 'code', 'barcode', 'name', 'group_code', 'status', 'idprice1', 'price1', 'idprice2', 'price2', 'sales', 'purchase', 'inventory'];

                // $columnsnow = Schema::getColumnListing('Luv2_item');

                // $fieldNames = [];
                // foreach ($dataudf as $field) {
                //     if ($field['active'] === 'Y') {
                //         $fieldNames[] = $field['field'];
                //     }
                // }

                // $columnsafterapi = array_merge($columnsdefault, $fieldNames);
                // $columnsToRemove = array_diff($columnsnow, $columnsafterapi);

                // foreach ($columnsToRemove as $columnName) {
                //     Schema::table('Luv2_item', function ($table) use ($columnName) {
                //         $table->dropColumn($columnName);
                //     });

                //     Schema::table('Luv2_item_temp', function ($table) use ($columnName) {
                //         $table->dropColumn($columnName);
                //     });
                // }

                // Get all columns from Luv2_item table
                $columnsLuv2ItemTesting = Schema::getColumnListing('Luv2_item');

                // Get all columns from Luv2_item_temp table
                $columnsLuv2ItemTestingTemp = Schema::getColumnListing('Luv2_item_temp');

                // Identify columns to remove from Luv2_item table
                $columnsToRemoveLuv2ItemTesting = array_diff($columnsLuv2ItemTesting, $columnsdefault);

                // Identify columns to remove from Luv2_item_temp table
                $columnsToRemoveLuv2ItemTestingTemp = array_diff($columnsLuv2ItemTestingTemp, $columnsdefaulttemp);

                // Drop columns from Luv2_item table
                foreach ($columnsToRemoveLuv2ItemTesting as $columnName) {
                    Schema::table('Luv2_item', function ($table) use ($columnName) {
                        $table->dropColumn($columnName);
                    });
                }

                // Drop columns from Luv2_item_temp table
                foreach ($columnsToRemoveLuv2ItemTestingTemp as $columnName) {
                    Schema::table('Luv2_item_temp', function ($table) use ($columnName) {
                        $table->dropColumn($columnName);
                    });
                }
                foreach ($dataudf as $field) {
                    if ($field['active'] === 'Y') {
                        $name = $field['field'];
                        $type = 'string';
                        $size = $field['size'];
                        // Check if the column already exists
                        if (!Schema::hasColumn('Luv2_item', $name)) {
                            Schema::table('Luv2_item', function (Blueprint $table) use ($name, $type, $size) {
                                $table->$type($name, $size)->nullable(); // Add the new field to the table
                            });
                        }
                        if (!Schema::hasColumn('Luv2_item_temp', $name)) {
                            Schema::table('Luv2_item_temp', function (Blueprint $table) use ($name, $type, $size) {
                                $table->$type($name, $size)->nullable(); // Add the new field to the table
                            });
                        }
                    }
                }
                if ($member_pricelist != '0') {
                    $fields = [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "c.\"CodeBars\" as \"barcode\"",
                        "name" => "c.\"ItemName\" as \"name\"",
                        "group_code" => "c.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "c.\"InvntItem\" as \"inventory\"",
                        "purchase" => "c.\"PrchseItem\" as \"purchase\"",
                        "sales" => "c.\"SellItem\" as \"sales\"",
                        "active" => "case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    ];
                    $noninv =  [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "a.\"CodeBars\" as \"barcode\"",
                        "name" => "a.\"ItemName\" as \"name\"",
                        "group_code" => "a.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "a.\"InvntItem\" as \"inventory\"",
                        "purchase" => "a.\"PrchseItem\" as \"purchase\"",
                        "sales" => "a.\"SellItem\" as \"sales\"",
                    ];
                } else {
                    $fields = [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "c.\"CodeBars\" as \"barcode\"",
                        "name" => "c.\"ItemName\" as \"name\"",
                        "group_code" => "c.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'0' as \"idprice2\"",
                        "price2" => "0 as \"price2\"",
                        "inventory" => "c.\"InvntItem\" as \"inventory\"",
                        "purchase" => "c.\"PrchseItem\" as \"purchase\"",
                        "sales" => "c.\"SellItem\" as \"sales\"",
                        "active" => "case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
                    ];
                    $noninv =  [
                        "code" => "a.\"ItemCode\" as \"code\"",
                        "barcode" => "a.\"CodeBars\" as \"barcode\"",
                        "name" => "a.\"ItemName\" as \"name\"",
                        "group_code" => "a.\"ItmsGrpCod\" as \"group_code\"",
                        "id_user" => "'" . $userId . "' as \"id_user\"",
                        "idprice1" => "'" . $id_pricelist . "' as \"idprice1\"",
                        "price1" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) as \"price1\"",
                        "idprice2" => "'" . $member_pricelist . "' as \"idprice2\"",
                        "price2" => "ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) as \"price2\"",
                        "inventory" => "a.\"InvntItem\" as \"inventory\"",
                        "purchase" => "a.\"PrchseItem\" as \"purchase\"",
                        "sales" => "a.\"SellItem\" as \"sales\"",
                    ];
                }
                $from = "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"";
                $fromnon = "OITM a";
                $where = "a.\"Warehouse\"='" . $whscode . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"";
                $wherenon = "a.\"InvntItem\"= 'N' group by a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",a.\"ItmsGrpCod\", a.\"InvntItem\", a.\"PrchseItem\", a.\"SellItem\"";

                $whereConditions = [];
                $wherenonInvCondition = [];
                foreach ($dataudf as $field) {
                    if ($field['active'] === 'Y') {
                        $fields[$field['field']] = "c.\"" . $field['field'] . "\"";
                        $whereConditions[] = "c.\"" . $field['field'] . "\"";
                        $wherenonInvCondition[] = "a.\"" . $field['field'] . "\"";
                        $noninv[$field['field']] = "a.\"" . $field['field'] . "\"";
                    }
                }

                $select = implode(',', $fields);
                $selectnon = implode(',', $noninv);

                $whereConditionsString = implode(',', $whereConditions);
                $wherenonInvConditionString = implode(',', $wherenonInvCondition);

                // Check if whereConditionsString is not empty before adding it to $where
                if (!empty($whereConditionsString)) {
                    $where .= ", " . $whereConditionsString;
                }

                // Check if wherenonInvConditionString is not empty before adding it to $wherenon
                if (!empty($wherenonInvConditionString)) {
                    $wherenon .= ", " . $wherenonInvConditionString;
                }

                // dd($select, $from, $where, $selectnon, $fromnon, $wherenon);
                $response = Http::post($url . '/api/search', [
                    "Select" => $select,
                    "From" => $from,
                    "Where" => $where,
                ]);

                $respnoninventory = Http::post($url . '/api/search', [
                    "Select" => $selectnon,
                    "From" => $fromnon,
                    "Where" => $wherenon,
                ]);

                $jsonData = $response->json();
                $jsonDataNonInv = $respnoninventory->json();
                $responseDiscPeriod = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"item_code\", c.\"CardCode\" as \"cardcode\" ,c.\"ListNum\" as \"id_pricelist\",c.\"FromDate\" as \"from_date\",CASE WHEN c.\"ToDate\" is NULL THEN '2999-12-31' ELSE c.\"ToDate\" end as \"to_date\",c.\"LINENUM\" as \"linenum\",c.\"Discount\" as \"disc\",c.\"Price\" as \"disc_price\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\"",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",c.\"CardCode\", c.\"ListNum\",c.\"FromDate\",c.\"ToDate\",c.\"LINENUM\",c.\"Discount\",c.\"Price\"",
                ]);

                $responseDiscQty = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\" as \"item_code\", d.\"CardCode\" as \"cardcode\", c.\"ListNum\" as \"id_pricelist\",d.\"Amount\" as \"qty\",d.\"Discount\" as \"disc\",d.\"Price\" as \"disc_price\",d.\"SPP1LNum\" as \"linenum_period\",d.\"SPP2LNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM a inner join SPP1 c on a.\"ItemCode\"=c.\"ItemCode\" inner join SPP2 d on c.\"ItemCode\"=d.\"ItemCode\" and c.\"LINENUM\"=d.\"SPP1LNum\" ",
                    "Where" => "a.\"Warehouse\"='" . $whscode . "' and c.\"ListNum\"='" . $id_pricelist . "' and a.\"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by a.\"ItemCode\",d.\"CardCode\", c.\"ListNum\",d.\"Amount\",d.\"Discount\",d.\"Price\",d.\"SPP1LNum\",d.\"SPP2LNum\"",
                ]);

                if ($response->successful() && $responseDiscPeriod->successful() && $responseDiscQty->successful() && $respnoninventory->successful()) {
                    $jsonData = $response->json();
                    $jsonDataNonInv = $respnoninventory->json();
                    $jsonDataDiscPeriod = $responseDiscPeriod->json();
                    $jsonDataDiscQty = $responseDiscQty->json();

                    ItemTemp::where('id_user', $userId)->delete();

                    if ($jsonData[0]['code'] != '') {
                        if (!empty($jsonData)) {
                            $chunks = array_chunk($jsonData, 1000);

                            foreach ($chunks as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertItem = [
                                        'code' => $item['code'],
                                        'barcode' => $item['barcode'],
                                        'name' => $item['name'],
                                        'group_code' => $item['group_code'],
                                        'id_user' => $userId,
                                        'idprice1' => $item['idprice1'],
                                        'price1' => $item['price1'],
                                        'idprice2' => $item['idprice2'],
                                        'price2' => $item['price2'],
                                        'inventory' => $item['inventory'],
                                        'sales' => $item['sales'],
                                        'purchase' => $item['purchase'],
                                    ];

                                    // Add additional fields dynamically
                                    foreach ($dataudf as $field) {
                                        if ($field['active'] === 'Y') {
                                            $fieldName = $field['field'];
                                            $insertItem[$fieldName] = $item[$fieldName] ?? null;
                                        }
                                    }

                                    $insertData[] = $insertItem;
                                }
                                DB::table('Luv2_item_temp')->insert($insertData);
                            }
                        }

                        if (!empty($jsonDataNonInv)) {
                            if ($jsonDataNonInv[0]['code'] != '') {

                                $chunks = array_chunk($jsonDataNonInv, 1000);

                                foreach ($chunks as $chunk) {
                                    $insertDataNonInv = [];

                                    foreach ($chunk as $item) {
                                        $insertItemnonInv = [
                                            'code' => $item['code'],
                                            'barcode' => $item['barcode'],
                                            'name' => $item['name'],
                                            'group_code' => $item['group_code'],
                                            'id_user' => $userId,
                                            'idprice1' => $item['idprice1'],
                                            'price1' => $item['price1'],
                                            'idprice2' => $item['idprice2'],
                                            'price2' => $item['price2'],
                                            'inventory' => $item['inventory'],
                                            'sales' => $item['sales'],
                                            'purchase' => $item['purchase'],
                                        ];

                                        // Add additional fields dynamically
                                        foreach ($dataudf as $field) {
                                            if ($field['active'] === 'Y') {
                                                $fieldName = $field['field'];
                                                $insertItemnonInv[$fieldName] = $item[$fieldName] ?? null;
                                            }
                                        }

                                        $insertDataNonInv[] = $insertItemnonInv;
                                    }
                                }
                                DB::table('Luv2_item_temp')->insert($insertDataNonInv);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscPeriod)) {
                        if ($jsonDataDiscPeriod[0]['item_code'] != '') {

                            $chunksDiscPeriod = array_chunk($jsonDataDiscPeriod, 1000);

                            foreach ($chunksDiscPeriod as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'from_date' => $item['from_date'],
                                        'to_date' => ($item['to_date'] === '?' || $item['to_date'] === '') ? '29991231' : $item['to_date'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],
                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc')->insert($insertData);
                            }
                        }
                    }

                    if (!empty($jsonDataDiscQty)) {
                        if ($jsonDataDiscQty[0]['item_code'] != '') {

                            $chunksDiscQty = array_chunk($jsonDataDiscQty, 1000);

                            foreach ($chunksDiscQty as $chunk) {
                                $insertData = [];

                                foreach ($chunk as $item) {
                                    $insertData[] = [
                                        'linenum' => $item['linenum'],
                                        'linenum_period' => $item['linenum_period'],
                                        'item_code' => $item['item_code'],
                                        'id_pricelist' => $item['id_pricelist'],
                                        'qty' => $item['qty'],
                                        'disc' => $item['disc'],
                                        'disc_price' => $item['disc_price'],
                                        'id_user' => $userId,
                                        'cardcode' => $item['cardcode'],

                                    ];
                                }

                                DB::table('Luv2_item_temp_pricelist_disc_qty')->insert($insertData);
                            }
                        }
                    }
                    // Construct the SELECT DISTINCT statement
                    $selectFields = [
                        "\"code\"",
                        "\"barcode\"",
                        "\"name\"",
                        "\"group_code\"",
                        "\"inventory\"",
                        "\"sales\"",
                        "\"purchase\"",
                    ];

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $selectFields[] = "\"{$field['field']}\"";
                        }
                    }

                    $selectStatement = implode(',', $selectFields);
                    // Construct the SQL statement
                    $sqlinsertitem = "
                                    INSERT INTO \"Luv2_item\" ($selectStatement) 
                                    SELECT DISTINCT $selectStatement
                                    FROM \"Luv2_item_temp\"
                                    WHERE NOT EXISTS (
                                        SELECT 1 FROM \"Luv2_item\" WHERE \"Luv2_item\".\"code\" = \"Luv2_item_temp\".\"code\"
                                    ) AND \"Luv2_item_temp\".\"id_user\" = '$userId'
                                ";

                    // Execute the SQL statement
                    DB::statement($sqlinsertitem);
                    $updateFields = [
                        "\"barcode\"=\"Luv2_item_temp\".\"barcode\"",
                        "\"name\"=\"Luv2_item_temp\".\"name\"",
                        "\"group_code\"=\"Luv2_item_temp\".\"group_code\"",
                        "\"inventory\"=\"Luv2_item_temp\".\"inventory\"",
                        "\"sales\"=\"Luv2_item_temp\".\"sales\"",
                        "\"purchase\"=\"Luv2_item_temp\".\"purchase\""
                    ];

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $updateFields[] = "\"$field[field]\"=\"Luv2_item_temp\".\"$field[field]\"";
                        }
                    }

                    $updateFieldsString = implode(', ', $updateFields);

                    $updateQuery = "
                        UPDATE \"Luv2_item\"
                        SET $updateFieldsString
                        FROM \"Luv2_item_temp\"
                        WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item\".\"code\" 
                        AND \"Luv2_item_temp\".\"id_user\"='$userId'
                        AND (
                            \"Luv2_item_temp\".\"barcode\"<>\"Luv2_item\".\"barcode\" OR
                            \"Luv2_item_temp\".\"name\"<>\"Luv2_item\".\"name\" OR
                            \"Luv2_item_temp\".\"group_code\"<>\"Luv2_item\".\"group_code\" OR
                            \"Luv2_item_temp\".\"inventory\"<>\"Luv2_item\".\"inventory\" OR
                            \"Luv2_item_temp\".\"sales\"<>\"Luv2_item\".\"sales\" OR
                            \"Luv2_item_temp\".\"purchase\"<>\"Luv2_item\".\"purchase\"";

                    foreach ($dataudf as $field) {
                        if ($field['active'] === 'Y') {
                            $updateQuery .= " OR 
                            \"Luv2_item_temp\".\"$field[field]\"<>\"Luv2_item\".\"$field[field]\" OR \"Luv2_item\".\"$field[field]\" is null";
                        }
                    }

                    $updateQuery .= ");";

                    DB::statement($updateQuery);

                    #insert price1
                    DB::statement("
                            INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                            SELECT DISTINCT \"code\", \"idprice1\", \"price1\"
                            FROM \"Luv2_item_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\" and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice1\") and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                        ");

                    #update price1
                    DB::statement("
                            UPDATE \"Luv2_item_pricelist\"
                            SET \"price\"=\"Luv2_item_temp\".\"price1\"
                            FROM \"Luv2_item_temp\"
                            WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice1\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                            AND \"Luv2_item_temp\".\"price1\"<>\"Luv2_item_pricelist\".\"price\";
                        ");

                    if ($member_pricelist != 0) {
                        #insert price2
                        DB::statement("
                                INSERT INTO \"Luv2_item_pricelist\" (\"item_code\", \"id_pricelist\", \"price\") 
                                SELECT DISTINCT \"code\", \"idprice2\", \"price2\"
                                FROM \"Luv2_item_temp\"
                                WHERE NOT EXISTS (
                                    SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_temp\".\"code\") and \"Luv2_item_pricelist\".\"id_pricelist\" = \"Luv2_item_temp\".\"idprice2\" and \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                            ");

                        #update price2
                        DB::statement("
                                UPDATE \"Luv2_item_pricelist\"
                                SET \"price\"=\"Luv2_item_temp\".\"price2\"
                                FROM \"Luv2_item_temp\"
                                WHERE \"Luv2_item_temp\".\"code\"=\"Luv2_item_pricelist\".\"item_code\" AND \"Luv2_item_temp\".\"idprice2\"=\"Luv2_item_pricelist\".\"id_pricelist\" AND \"Luv2_item_temp\".\"id_user\"='" . $userId . "'
                                AND \"Luv2_item_temp\".\"price2\"<>\"Luv2_item_pricelist\".\"price\";
                            ");
                    }


                    #insert disc period
                    DB::statement("
                                INSERT INTO \"Luv2_item_pricelist_disc\" (\"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\")
                                SELECT DISTINCT \"cardcode\", \"linenum\", \"item_code\", \"id_pricelist\", \"from_date\", \"to_date\", \"disc\", \"disc_price\"
                                FROM \"Luv2_item_temp_pricelist_disc\"
                                WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_pricelist_disc\" WHERE \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\") and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                            ");

                    #update disc period
                    DB::statement("
                                UPDATE \"Luv2_item_pricelist_disc\"
                                SET \"from_date\"=\"Luv2_item_temp_pricelist_disc\".\"from_date\",\"to_date\"=\"Luv2_item_temp_pricelist_disc\".\"to_date\",\"disc\"=\"Luv2_item_temp_pricelist_disc\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                                FROM \"Luv2_item_temp_pricelist_disc\"
                                WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "'
                                AND (
                                    \"Luv2_item_pricelist_disc\".\"from_date\"<>\"Luv2_item_temp_pricelist_disc\".\"from_date\" OR
                                    \"Luv2_item_pricelist_disc\".\"to_date\"<>\"Luv2_item_temp_pricelist_disc\".\"to_date\" OR
                                    \"Luv2_item_pricelist_disc\".\"disc\"<>\"Luv2_item_temp_pricelist_disc\".\"disc\" OR
                                    \"Luv2_item_pricelist_disc\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc\".\"disc_price\"
                                );
                            ");

                    // #delete pricelist
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc\" SET \"deleted\"='Y';
                    //     ");

                    // #delete pricelist
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc\"
                    //         SET \"deleted\"='N'
                    //         FROM \"Luv2_item_temp_pricelist_disc\"
                    //         WHERE \"Luv2_item_pricelist_disc\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc\".\"cardcode\" and \"Luv2_item_pricelist_disc\".\"linenum\" = \"Luv2_item_temp_pricelist_disc\".\"linenum\" and \"Luv2_item_pricelist_disc\".\"item_code\" = \"Luv2_item_temp_pricelist_disc\".\"item_code\" and \"Luv2_item_pricelist_disc\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc\".\"id_pricelist\" and \"Luv2_item_temp_pricelist_disc\".\"id_user\"='" . $userId . "';
                    //     ");
                    // #delete pricelist
                    // DB::statement("
                    //         DELETE FROM \"Luv2_item_pricelist_disc\" WHERE \"deleted\"='Y';
                    //     ");


                    #insert disc qty
                    DB::statement("
                     INSERT INTO \"Luv2_item_pricelist_disc_qty\" (\"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\") 
                     SELECT DISTINCT \"cardcode\", \"linenum\", \"linenum_period\", \"item_code\", \"id_pricelist\", \"qty\", \"disc\", \"disc_price\"
                     FROM \"Luv2_item_temp_pricelist_disc_qty\"
                     WHERE NOT EXISTS (
                         SELECT 1 FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\") and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "'
                 ");

                    #update disc qty
                    DB::statement("
                    UPDATE \"Luv2_item_pricelist_disc_qty\"
                    SET \"qty\"=\"Luv2_item_temp_pricelist_disc_qty\".\"qty\",\"disc\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc\",\"disc_price\"=\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                    FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' 
                    AND (
                        \"Luv2_item_pricelist_disc_qty\".\"qty\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"qty\" OR
                        \"Luv2_item_pricelist_disc_qty\".\"disc\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc\" OR
                        \"Luv2_item_pricelist_disc_qty\".\"disc_price\"<>\"Luv2_item_temp_pricelist_disc_qty\".\"disc_price\"
                    );
                ");

                    // #delete pricelist
                    // DB::statement("
                    //     UPDATE \"Luv2_item_pricelist_disc_qty\" SET \"deleted\"='Y';
                    // ");

                    // #delete discqty
                    // DB::statement("
                    //         UPDATE \"Luv2_item_pricelist_disc_qty\"
                    //         SET \"deleted\"='N' 
                    //         FROM \"Luv2_item_temp_pricelist_disc_qty\"
                    //         WHERE \"Luv2_item_pricelist_disc_qty\".\"linenum\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum\" and \"Luv2_item_pricelist_disc_qty\".\"linenum_period\" = \"Luv2_item_temp_pricelist_disc_qty\".\"linenum_period\" and \"Luv2_item_pricelist_disc_qty\".\"item_code\" = \"Luv2_item_temp_pricelist_disc_qty\".\"item_code\" and \"Luv2_item_pricelist_disc_qty\".\"id_pricelist\" = \"Luv2_item_temp_pricelist_disc_qty\".\"id_pricelist\" and \"Luv2_item_pricelist_disc_qty\".\"cardcode\" = \"Luv2_item_temp_pricelist_disc_qty\".\"cardcode\" and \"Luv2_item_temp_pricelist_disc_qty\".\"id_user\"='" . $userId . "' ;
                    //     ");
                    // DB::statement("
                    //     DELETE FROM \"Luv2_item_pricelist_disc_qty\" WHERE \"deleted\"='Y';
                    // ");

                    ItemTemp::where('id_user', $userId)->delete();

                    $this->alert('success', 'Data Item Synchrone succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('finish');
                    $this->dispatch('aftergetSAPTraits');
                } else {
                    $this->alert('info', 'Theres no data to synchrone', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloadingitem = false;
                    $this->dispatch('aftergetSAPTraits');
                }
            } else {
                $this->alert('info', 'Theres no data Item', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isloadingitem = false;
                $this->dispatch('aftergetSAPTraits');
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                // Do something or re-do the function
                $this->reDoFunction('getItemwithUDFandFilter');
            } else {
                // Handle other errors
                throw $e; // Re-throw the error
            }
        }
    }
}
