<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    use HasFactory;

    protected $table = 'Luv2_warehouse';
    protected $fillable = [
        'code',
        'name',
        'id_company',
        'id_pricelist',
        'cashacc',
        'cardacc',
        'active',
        'bpl_id',
        'sbu', 
        'cardcode', 
        'address', 
        'phone', 
        'email', 
        'footer', 
        'updated_at',
    ];

    public function user()
    {
        return $this->hasMany(User::class, 'id');
    }

    public function pricelist()
    {
        return $this->belongsTo(ItemPrice::class, 'id_pricelist');
    }

    public function itIn()
    {
        return $this->hasMany(ItIn::class, 'code', 'whs_code_from');
    }
}
