<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sales extends Model
{
    use HasFactory;
    protected $table = 'Luv2_salesemp';
    protected $primaryKey = 'code';
    public $incrementing = false; 
    public $timestamps = false;
    protected $fillable = 
    [
        'code',
        'name',
        'position',
        'status',
    ];

    public function carts()
    {
        return $this->hasMany(Cart::class, 'id_sales', 'code');
    }
}
