<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    use HasFactory;

    protected $table = 'Luv2_item';
    public $timestamps = false;
    protected $fillable = 
    [
        'code',
        'barcode',
        'name',
        'group_code',
        'status',
        'id',
    ];

    public function itemPrices()
    {
        return $this->hasMany(ItemPrice::class, 'code', 'item_code');
    }
    
}
