<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItOutTemp extends Model
{
    use HasFactory;

    protected $table = 'Luv2_it_out_temp';
    protected $fillable = [
        'whs_code',
        'whs_code_to',
        'date',
        'no',
        'canceled',
        'comments',
        'id_user'
    ];

    public function whs()
    {
        return $this->belongsTo(Warehouse::class, 'id_whs');
    }

    public function whsFrom()
    {
        return $this->belongsTo(Warehouse::class, 'id_whs_to');
    }
}
