<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;


class Cart extends Model
{
    use HasFactory, LogsActivity;
    
    protected $table = 'Luv2_carts';
    protected static $logOnlyDirty = true;
    protected static $recordEvents = ['deleted', 'updated'];
    protected $fillable = 
    [
        'code',
        'barcode',
        'name',
        'price',
        'nprice',
        'sandbox',
        'qty',
        'id_member',
        'id_sales',
        'id_user',
        'total_price',
        'discount',
        'created_at',
        'promo',
        'promo_tipe',
        'pack',
        'benefit',
        'grouping'
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('Scan')
        ->logFillable()
        ->setDescriptionForEvent(fn(string $eventName) => "This data has been {$eventName}");
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'id_member', 'code');
    }

    public function kasir()
    {
        return $this->belongsTo(Member::class, 'id_user', 'id');
    }

    public function sales()
    {
        return $this->belongsTo(Member::class, 'id_sales', 'code');
    }
}
