<?php

namespace App\Livewire\Synchronization;

use App\Models\Settings;
use App\Models\User;
use App\Models\UserAuths;
use App\Models\Warehouse;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class Index extends Component
{

    use LivewireAlert;

    public $isloadingUser = false;
    public $isloadingAuth = false;
    public $isloadingWarehouse = false;
    public $isloadingSetting = false;

    public function render()
    {
        return view('livewire.synchronization.index');
    }

    public function test()
    {
        $idcompany = session('id_company');
        $setting = Settings::first();
        // $user = Http::get($setting->url_admin . 'user/' . $idcompany)->json();
        // $warehouse = Http::get($setting->url_admin . 'warehouse/30')->json();
        // $user_auth = Http::get($setting->url_admin . 'user_auth/30')->json();
        $setting = Http::get($setting->url_admin . 'setting/30')->json();

        dd($setting);
        
    }

    public function clickUser()
    {
        $this->isloadingUser = true;
        $this->dispatch('tosyncUser');
    }
    public function clickAuth()
    {
        $this->isloadingAuth = true;
        $this->dispatch('tosyncAuth');
    }
    public function clickWarehouse()
    {
        $this->isloadingWarehouse = true;
        $this->dispatch('tosyncWarehouse');
    }
    public function clickSetting()
    {
        $this->isloadingSetting = true;
        $this->dispatch('tosyncSetting');
    }

    #[On('tosyncUser')]
    public function syncUser()
    {

        $setting = Settings::first();
        $idcompany = session('id_company') ?? $setting->id_company;
        $user = Http::get($setting->url_admin . 'user/' . $idcompany)->json();
        foreach ($user as $item) {
            $existingUser = User::where('name', $item['username'])->first();
            
            if ($existingUser) {
                $existingUser->update([
                    'password' => $item['password'],
                    'id_company' => $item['id_company'],
                    'whs_code' => $item['whs_code'],
                    'active' => $item['active'],
                    'updated_at' => $item['updated_at'],
                ]);
            } else {
                User::create([
                    'name' => $item['username'],
                    'password' => $item['password'],
                    'id_company' => $item['id_company'],
                    'whs_code' => $item['whs_code'],
                    'active' => $item['active'],
                    'created_at' => $item['created_at'],
                    'updated_at' => $item['updated_at'],
                ]);
            }
        }
        $this->alert('success', 'Data user updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingUser = false;
    }

    #[On('tosyncAuth')]
    public function syncAuth()
    {
        $setting = Settings::first();
        $idcompany = session('id_company') ?? $setting->id_company;
        $userauth = Http::get($setting->url_admin . 'user_auth/' . $idcompany)->json();
        foreach ($userauth as $item) {
            $existingAuth = UserAuths::where('id_user', $item['id_user'])
                                    ->where('id_auth', $item['id_auth'])->first();
            
            if ($existingAuth) {
                $existingAuth->update([
                    'auth' => $item['auth'],
                    'updated_at' => $item['updated_at'],
                ]);
            } else {
                UserAuths::create([
                    'id_user' => $item['id_user'],
                    'id_auth' => $item['id_auth'],
                    'auth' => $item['auth'],
                    'created_at' => $item['created_at'],
                    'updated_at' => $item['updated_at'],
                    'created_at' => $item['created_at'],
                    'id_company' => $item['id_company'],
                ]);
            }
        }
        $this->alert('success', 'Data user auth updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingAuth = false;
    }


    #[On('tosyncWarehouse')]
    public function syncWarehouse()
    {
        $setting = Settings::first();
        $idcompany = session('id_company') ?? $setting->id_company;
        $warehouse = Http::get($setting->url_admin . 'warehouse/' . $idcompany)->json();
        foreach ($warehouse as $item) {
            $existingWarehouse = DB::table('Luv2_warehouse')->where('code', $item['code'])->first();
            
            if ($existingWarehouse) {
                DB::table('Luv2_warehouse')->where('code', $item['code'])->update([
                    'name' => $item['name'],
                    'id_pricelist' => $item['id_pricelist'],
                    'cashacc' => $item['cashacc'],
                    'cardacc' => $item['cardacc'],
                    'active' => $item['active'],
                    'bpl_id' => $item['bpl_id'],
                    'sbu' => $item['sbu'], 
                    'cardcode' => $item['cardcode'], 
                    'address' => $item['address'], 
                    'phone' => $item['phone'], 
                    'email' => $item['email'], 
                    'footer' => $item['footer'], 
                    'cost1' => $item['cost1'],
                    'cost2' => $item['cost2'],
                    'cost3' => $item['cost3'],
                    'cost4' => $item['cost4'],
                    'cost5' => $item['cost5'],
                ]);
            } else {
                DB::table('Luv2_warehouse')->insert([
                    'code' => $item['code'],
                    'name' => $item['name'],
                    'id_pricelist' => $item['id_pricelist'],
                    'cashacc' => $item['cashacc'],
                    'cardacc' => $item['cardacc'],
                    'active' => $item['active'],
                    'bpl_id' => $item['bpl_id'],
                    'sbu' => $item['sbu'], 
                    'cardcode' => $item['cardcode'], 
                    'address' => $item['address'], 
                    'phone' => $item['phone'], 
                    'email' => $item['email'], 
                    'footer' => $item['footer'],
                    'cost1' => $item['cost1'],
                    'cost2' => $item['cost2'],
                    'cost3' => $item['cost3'],
                    'cost4' => $item['cost4'],
                    'cost5' => $item['cost5'],
                ]);
            }
        }
        $this->alert('success', 'Data warehouse updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingWarehouse = false;
    }

    #[On('tosyncSetting')]
    public function syncSetting()
    {
        $setting = Settings::first();
        $idcompany = session('id_company') ?? $setting->id_company;
        $whscode = $setting->wh_code;
        $urladmin = $setting->url_admin;
        $setting = Http::get($urladmin . 'setting/' . $idcompany)->json();
        
        foreach ($setting as $item) {
            $existingSetting = DB::table('Luv2_settings')->where('id_company', $item['id_company'])->first();
            
            if ($existingSetting) {
                DB::table('Luv2_settings')->where('id_company', $item['id_company'])->update([
                    'id_company' => $item['id_company'],
                    'member' => $item['member'],
                    'member_pricelist' => $item['member_pricelist'],
                    'member_disc' => $item['member_disc'],
                    'auto_report' => $item['auto_report'],
                    'url' => $item['url'],
                    'email_sandbox' => $item['email_sandbox'],
                    'email_finance' => $item['email_finance'],
                    'member_prefix' => $item['member_prefix'],
                    'member_group' => $item['member_group'],
                ]);
            } else {
                Settings::create([
                    'id_company' => $item['id_company'],
                    'member' => $item['member'],
                    'member_pricelist' => $item['member_pricelist'],
                    'member_disc' => $item['member_disc'],
                    'auto_report' => $item['auto_report'],
                    'url' => $item['url'],
                    'email_sandbox' => $item['email_sandbox'],
                    'email_finance' => $item['email_finance'],
                    'member_prefix' => $item['member_prefix'],
                    'member_group' => $item['member_group'],
                ]);
            }
        }
        $this->alert('success', 'Data setting updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingSetting = false;
    }
   
}
