<?php

namespace App\Livewire\Returnsale;

use Livewire\Attributes\On;
use Livewire\Component;

class SelectDiscount extends Component
{

    public $dataDisc = [];
    public $button = '';
    public $title = '';
    public $selectedPromo;
    public $openmodalDisc = false;
    public $product;
    public $prices;
    public $pricelist;

    public function render()
    {
        return view('livewire.returnsale.select-discount');
    }

    #[On('selectDiscount')]
    public function updatedDatadisc($product, $prices, $dataDisc, $pricelist)
    {
        $dataDiscFilter = [];
        foreach ($dataDisc as $record) {
            $no = $record['no'];
            $pack = $record['pack'];
            if (!isset($dataDiscFilter[$no]) || $pack < $dataDiscFilter[$no]['pack']) {
                $dataDiscFilter[$no] = $record;
            }
        }
        $this->product = $product;
        $this->prices = $prices;
        $this->pricelist = $pricelist;

        $dataDiscFilter = array_values($dataDiscFilter); // Re-index the array if necessary
        $this->dataDisc = $dataDiscFilter;
        $this->button = 'save';
        $this->title = 'Select Discount';
        $this->selectedPromo = !empty($this->dataDisc) ? $this->dataDisc[0]['no'] : null;

        $this->dispatch('openModalSelect')->to(Newitem::class);
    }

    #[On('selectValue')]
    public function updatedDatadiscvalue($dataDisc)
    {
        $this->dataDisc = $dataDisc;
        $this->button = 'saveValue';
        $this->title = 'Select Promo by Value';
        $this->selectedPromo = !empty($this->dataDisc) ? $this->dataDisc[0]['no'] : null;
        $this->dispatch('openModalSelect')->to(Table::class);
    }
    

    public function save()
    {
        $selectedDiscountData = collect($this->dataDisc)->firstWhere('no', $this->selectedPromo);
        $this->dispatch('selectedDiscountData', $this->product, $this->prices, $selectedDiscountData, $this->pricelist)->to(Newitem::class);
        $this->openmodalDisc = false;
        
        $this->dispatch('closeModalDisc');
        $this->dispatch('closeModalDisctoTransaction')->to(Table::class);

    }

    public function saveValue()
    {
        $selectedValueData =  $this->selectedPromo;
        $this->dispatch('selectedValueData', $selectedValueData)->to(Newitem::class);
        $this->openmodalDisc = false;

        $this->dispatch('closeModalDisc');
        $this->dispatch('closeModalDisctoTransaction')->to(Table::class);

    }
    
}
