<?php

namespace App\Livewire\Report;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Voucher extends Component
{

    public $data;

    public function render()
    {
        return view('livewire.report.voucher');
    }

    public function mount()
    {
        $data = DB::table('Luv2_promo_voucher')
        ->leftjoin('Luv2_promo', 'Luv2_promo_voucher.no', '=', 'Luv2_promo.no')
        ->leftJoin('Luv2_invoice', 'Luv2_promo_voucher.voucher', '=', 'Luv2_invoice.cashback')
        ->select(
            'Luv2_promo_voucher.no',
            'Luv2_promo_voucher.id_company',
            'Luv2_promo_voucher.voucher',
            'Luv2_promo_voucher.value',
            'Luv2_promo_voucher.used',
            'Luv2_promo.id_pricelist',
            'Luv2_promo.name',
            'Luv2_promo.from_date',
            'Luv2_promo.to_date',
            'Luv2_promo.deleted',
            'Luv2_promo.tipe',
            'Luv2_promo.benefit',
            'Luv2_promo.date',
            'Luv2_promo.disc',
            'Luv2_promo.disc_price',
            'Luv2_promo.qty_pack',
            'Luv2_promo.value_pack',
            'Luv2_promo.voucher_from_date',
            'Luv2_promo.voucher_to_date',
            'Luv2_promo.invoice as createdBy',
            'Luv2_promo.sync',
            'Luv2_invoice.no as usedBy' 
        )
        ->get();
    
        $this->data = $data;

    }
}
