<?php

namespace App\Livewire\Report;

use Livewire\Component;
use App\Exports\ExportARInvoiceDetail;
use App\Exports\ExportARItemDetail;
use App\Exports\ExportInvoice;
use App\Exports\ExportInvoiceDetail;
use App\Exports\ExportReturnDetail;
use App\Models\DetailInvoice;
use App\Models\Invoice as ModelsInvoice;
use App\Models\ItemTemp;
use App\Models\ItemTransTemp;
use App\Models\Member;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Schema;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Maatwebsite\Excel\Facades\Excel;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\CapabilityProfile;
use Mike42\Escpos\Printer;


class Bjrs extends Component
{

    use LivewireAlert;

    public $invoiceNo = false;
    public $checkboxes = [];
    public $selectAll = false;
    public $cardcode;
    public $datadetail;
    public $startDate;
    public $endDate;
    public $type;
    public $invoices;
    public $returnsale;
    public $data;
    public $isloadingsync;
    public $isloadingreturn;
    public $loadingsap = false;
    public $selectedType = false;
    public $processing = false;
    public $conn = '';
    public $isFilter = false;


    #[On('syncCompleted')]
    public function mount()
    {

        $invoices = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
            ->where(function ($query) {
                $startDate = $this->startDate ?? Carbon::now()->format('Y-m-d');
                $endDate = $this->endDate ?? Carbon::now()->format('Y-m-d');

                if ($startDate === $endDate) {
                    $query->whereDate('Luv2_invoice.created_at', '=', $startDate);
                } else {
                    $endDate = date('Y-m-d 23:59:59', strtotime($endDate));

                    $query->whereBetween('Luv2_invoice.created_at', [$startDate, $endDate]);
                }

                if ($this->type == 'BJ') {
                    $query->whereNull('Luv2_invoice.no_inv');
                } elseif ($this->type == 'RS') {
                    $query->whereNotNull('Luv2_invoice.no_inv');
                }
            })
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_users.name as users_name'
            )
            ->orderBy('Luv2_invoice.created_at', 'DESC')
            ->get();
        $uniqueCardCodes = DB::table('Luv2_invoice')
            ->distinct()
            ->pluck('cardcode');
        $membersWithMatchingCodes = DB::table('Luv2_member')
            ->whereIn('code', $uniqueCardCodes)
            ->get();
        $cardcodes = $membersWithMatchingCodes;
        $this->invoices = $invoices;
        $this->cardcode = $cardcodes;
        $this->invoices = $this->invoices->map(function ($invoice) {
            if ($invoice->note) {
                $invoiceNote = json_decode($invoice->note, true);

                $cash = $invoiceNote['cash'];
                $transfer = $invoiceNote['transfer'];

                $invoice->cash = $cash;
                $invoice->transfer = $transfer;
            }
            if ($invoice->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $cekvoucher->value;
                $invoice->value = $vouchervalue;
            }
            return $invoice;
        });
        $this->returnsale = $this->invoices
            ->whereNotNull('no_inv')
            ->map(function ($returnsale) {
                $detail = ModelsInvoice::where('no', $returnsale->no_inv)->first();

                $returnsale->price = $returnsale->must_paid < 0 ? 0 : abs($returnsale->must_paid);

                return $returnsale;
            });
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->dispatch('refreshjs');
        if ($this->invoices->isEmpty()) {
            $this->dispatch('noDataToday');

            // Data for today is empty, fetch the latest available data
            $latestData = DB::table('Luv2_invoice')
                ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
                ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
                ->where(function ($query) {
                    // Adding the condition for filtering by "Type Invoice"
                    if ($this->type == 'BJ') {
                        $query->whereNull('Luv2_invoice.no_inv');
                    } elseif ($this->type == 'RS') {
                        $query->whereNotNull('Luv2_invoice.no_inv');
                    }
                })
                ->select(
                    'Luv2_invoice.*',
                    'Luv2_salesemp.name as sales_name',
                    'Luv2_users.name as users_name'
                )
                ->orderBy('Luv2_invoice.created_at', 'DESC')
                ->first();

            if ($latestData !== null) {
                $latestDate = Carbon::parse($latestData->created_at)->format('Y-m-d');
                $this->invoices = DB::table('Luv2_invoice')
                    ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
                    ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
                    ->whereDate('Luv2_invoice.created_at', '=', $latestDate)
                    ->where(function ($query) {
                        if ($this->type == 'BJ') {
                            $query->whereNull('Luv2_invoice.no_inv');
                        } elseif ($this->type == 'RS') {
                            $query->whereNotNull('Luv2_invoice.no_inv');
                        }
                    })
                    ->select(
                        'Luv2_invoice.*',
                        'Luv2_salesemp.name as sales_name',
                        'Luv2_users.name as users_name'
                    )
                    ->orderBy('Luv2_invoice.created_at', 'DESC')
                    ->get();
                $latestDate = Carbon::parse($latestData->created_at)->format('Y-m-d');
                $this->startDate = $latestDate;
            } else {
                // No data available
                $this->dispatch('noDataAvailable');
                $this->invoices = collect(); // An empty collection
                $this->startDate = Carbon::now()->format('Y-m-d');
            }
        } else {
            // Use data for today
            $this->invoices = $invoices;
        }
        $this->endDate = Carbon::now()->format('Y-m-d');
    }

    public function test()
    {
        try {
            // Make a GET request to a reliable website
            $response = Http::get('https://www.google.com');

            // Check if the status code is 200 (OK)
            if ($response->status() === 200) {
                // Internet connection is available
                $this->conn = "available!";
            } else {
                // Internet connection is not available
                $this->conn = "not available!";
            }
        } catch (Exception $e) {
            // An exception occurred, indicating no conn connection
            $this->conn = "not available!";
        }
    }

    public function test2()
    {
        $user = Auth::user();
        $setting = Settings::first();
        $prefix = $setting->member_prefix;
        $url = $setting->url;
        $urladmin = $setting->url_admin;
        $prefix = $setting->member_prefix;
        $currentYear = date('y');
        $currentMonth = date('m');
        $uniqueId = $prefix . $currentYear . $currentMonth;
        $response = Http::get($urladmin . 'member/' . $setting->id_company . '/' . $uniqueId);
        // $data = [
        //     'id_company' => 30,
        //     'code' => $uniqueId . '0001',
        //     'name' => 'Test bang',
        //     'email' => 'adiganteng630@gmail.com',
        //     'phone' => '089621791541',
        //     'address' => '-',
        //     'hobby' => 'Memancing',
        //     'active' => 'N',
        // ];

        // $responsedata = Http::post($urladmin . 'member', $data);
        // $jsonData2 = $responsedata->json();
        // dd($jsonData2);

        $jsonData = $response->json();

        if (isset($jsonData['error']) && $jsonData['error'] === 'Member not found') {
            $runningCode = '0001';
            dd($runningCode);
        } else {
            $jsonData = $response->json();
            $cardcode = $jsonData['code'];
            $runningNumber = substr($cardcode, -4);
            $newNumericPart = str_pad((int)$runningNumber + 1, strlen($runningNumber), '0', STR_PAD_LEFT);
            $newrunningNumber = $newNumericPart;

            dd($newrunningNumber);
        }
    }

    public function updateCheckboxes($crdcd)
    {
        $this->checkboxes[$crdcd] = !$this->checkboxes[$crdcd];
    }

    public function filterInvoices()
    {
        if ($this->selectAll) {
            $this->checkboxes = [];
        };

        $invoices = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
            ->where(function ($query) {
                $startDate = $this->startDate ?? Carbon::now()->format('Y-m-d');
                $endDate = $this->endDate ?? Carbon::now()->format('Y-m-d');

                if ($startDate === $endDate) {
                    $query->whereDate('Luv2_invoice.created_at', '=', $startDate);
                } else {
                    $endDate = date('Y-m-d 23:59:59', strtotime($endDate));
                    // dd($endDate);

                    $query->whereBetween('Luv2_invoice.created_at', [$startDate, $endDate]);
                }

                if ($this->type == 'BJ') {
                    $query->whereNull('Luv2_invoice.no_inv');
                } elseif ($this->type == 'RS') {
                    $query->whereNotNull('Luv2_invoice.no_inv');
                }
                $selectedCardCodes = array_keys(array_filter($this->checkboxes));
                if (!empty($selectedCardCodes)) {
                    $query->whereIn('Luv2_invoice.cardcode', $selectedCardCodes);
                }
            })
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_users.name as users_name'
            )
            ->orderBy('Luv2_invoice.created_at', 'DESC')
            ->get();


        $this->invoices = $this->invoices->map(function ($invoice) {
            $invoice->grandtotal = $invoice->must_paid;

            if ($invoice->note) {
                $invoiceNote = json_decode($invoice->note, true);

                $cash = $invoiceNote['cash'];
                $transfer = $invoiceNote['transfer'];

                $invoice->cash = $cash;
                $invoice->transfer = $transfer;
            }
            if ($invoice->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $cekvoucher->value;
                $invoice->value = $vouchervalue;
            }
            return $invoice;
        });
        $this->returnsale = $this->invoices
            ->whereNotNull('no_inv')
            ->map(function ($returnsale) {
                $detail = ModelsInvoice::where('no', $returnsale->no_inv)->first();

                $returnsale->price = $returnsale->must_paid < 0 ? 0 : abs($returnsale->must_paid);

                return $returnsale;
            });
        // dd($this->startDate, $this->endDate);
        $this->invoices = $invoices;

        $this->dispatch('refreshjs');
        $this->selectedType = true;
        $this->isFilter = true;
    }

    public function clearFilter()
    {
        $invoices = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
            ->where(function ($query) {
                $startDate = Carbon::now()->format('Y-m-d');
                $endDate = Carbon::now()->format('Y-m-d');

                if ($startDate === $endDate) {
                    $query->whereDate('Luv2_invoice.created_at', '=', $startDate);
                } else {
                    $endDate = date('Y-m-d 23:59:59', strtotime($endDate));

                    $query->whereBetween('Luv2_invoice.created_at', [$startDate, $endDate]);
                }

                if ($this->type == 'BJ') {
                    $query->whereNull('Luv2_invoice.no_inv');
                } elseif ($this->type == 'RS') {
                    $query->whereNotNull('Luv2_invoice.no_inv');
                }
            })
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_users.name as users_name'
            )
            ->orderBy('Luv2_invoice.created_at', 'DESC')
            ->get();
        $this->invoices = $invoices;
        $this->invoices = $this->invoices->map(function ($invoice) {

            $invoice->grandtotal = $invoice->must_paid;

            if ($invoice->note) {
                $invoiceNote = json_decode($invoice->note, true);

                $cash = $invoiceNote['cash'];
                $transfer = $invoiceNote['transfer'];

                $invoice->cash = $cash;
                $invoice->transfer = $transfer;
            }
            if ($invoice->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $cekvoucher->value;
                $invoice->value = $vouchervalue;
            }
            return $invoice;
        });
        $this->returnsale = $this->invoices
            ->whereNotNull('no_inv')
            ->map(function ($returnsale) {
                $detail = ModelsInvoice::where('no', $returnsale->no_inv)->first();

                $returnsale->price = $returnsale->must_paid < 0 ? 0 : abs($returnsale->must_paid);

                return $returnsale;
            });
        $this->selectedType = false;
        $this->isFilter = false;
        $this->dispatch('refreshjs');
        if ($this->invoices->isEmpty()) {
            $this->dispatch('noDataToday');

            // Data for today is empty, fetch the latest available data
            $latestData = DB::table('Luv2_invoice')
                ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
                ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
                ->where(function ($query) {
                    // Adding the condition for filtering by "Type Invoice"
                    if ($this->type == 'BJ') {
                        $query->whereNull('Luv2_invoice.no_inv');
                    } elseif ($this->type == 'RS') {
                        $query->whereNotNull('Luv2_invoice.no_inv');
                    }
                })
                ->select(
                    'Luv2_invoice.*',
                    'Luv2_salesemp.name as sales_name',
                    'Luv2_users.name as users_name'
                )
                ->orderBy('Luv2_invoice.created_at', 'DESC')
                ->first();

            if ($latestData !== null) {
                $latestDate = Carbon::parse($latestData->created_at)->format('Y-m-d');
                $this->invoices = DB::table('Luv2_invoice')
                    ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
                    ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
                    ->whereDate('Luv2_invoice.created_at', '=', $latestDate)
                    ->where(function ($query) {
                        if ($this->type == 'BJ') {
                            $query->whereNull('Luv2_invoice.no_inv');
                        } elseif ($this->type == 'RS') {
                            $query->whereNotNull('Luv2_invoice.no_inv');
                        }
                    })
                    ->select(
                        'Luv2_invoice.*',
                        'Luv2_salesemp.name as sales_name',
                        'Luv2_users.name as users_name'
                    )
                    ->orderBy('Luv2_invoice.created_at', 'DESC')
                    ->get();
                $latestDate = Carbon::parse($latestData->created_at)->format('Y-m-d');
                $this->startDate = $latestDate;
                $this->endDate = Carbon::now()->format('Y-m-d');
            } else {
                // No data available
                $this->dispatch('noDataAvailable');
                $this->invoices = collect(); // An empty collection
                $this->startDate = Carbon::now()->format('Y-m-d');
                $this->endDate = Carbon::now()->format('Y-m-d');
            }
        } else {
            // Use data for today
            $this->invoices = $invoices;
            $this->startDate = Carbon::now()->format('Y-m-d');
            $this->endDate = Carbon::now()->format('Y-m-d');
        }
    }


    #[On('refresh')]
    public function render()
    {
        $this->invoices = $this->invoices->map(function ($invoice) {
            $invoice->grandtotal = $invoice->must_paid;

            if ($invoice->note) {
                $invoiceNote = json_decode($invoice->note, true);

                $cash = $invoiceNote['cash'];
                $transfer = $invoiceNote['transfer'];

                $invoice->cash = $cash;
                $invoice->transfer = $transfer;
            }
            if ($invoice->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $cekvoucher->value;
                $invoice->value = $vouchervalue;
            }
            return $invoice;
        });

        $this->returnsale = $this->invoices
            ->whereNotNull('no_inv')
            ->map(function ($returnsale) {
                $detail = ModelsInvoice::where('no', $returnsale->no_inv)->first();

                $returnsale->price = $returnsale->must_paid < 0 ? 0 : abs($returnsale->must_paid);

                return $returnsale;
            });
        $synccount = ModelsInvoice::where('sync', 'N')->count();
        return view('livewire.report.bjrs', [
            'invoices' => $this->invoices,
            'syncount' => $synccount,
            'returnsale' => $this->returnsale,
        ]);
    }

    public function exportExcelDetail($code)
    {
        $data = DetailInvoice::where('invoice', $code)->get();
        $invoicesdetail = $data;
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Invoice Detail Report - {$now}.xlsx";
        } else {
            $filename = "Invoice Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        $this->dispatch('refreshjs');

        return Excel::download(new ExportInvoiceDetail($invoicesdetail), $filename);
    }
    public function exportreturnExcelDetail($code)
    {
        $datareturn = DetailInvoice::where('invoice', $code)
            ->where('status', 1)->get();
        $databuy = DetailInvoice::where('invoice', $code)
            ->where('status', 0)->get();
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Return Sale Detail Report - {$now}.xlsx";
        } else {
            $filename = "Return Sale Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        return Excel::download(new ExportReturnDetail($datareturn, $databuy), $filename);
    }
    public function exportExcel()
    {
        $invoices = $this->invoices;
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Invoice Report - {$now}.xlsx";
        } else {
            $filename = "Invoice Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        $this->dispatch('refreshjs');
        return Excel::download(new ExportInvoice($invoices), $filename);
    }

    public function exportARItemDetail()
    {
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        $data = [
            'startDate' => $this->startDate,
            'endDate' => $this->endDate,
            'type' => $this->type,
            'checkboxes' => $this->checkboxes,

        ];
        if ($this->startDate === null) {
            $filename = "AR Invoice Report - {$now}.xlsx";
        } else {
            $filename = "AR Invoice Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        $this->dispatch('refreshjs');

        return Excel::download(new ExportARItemDetail($data), $filename);
    }

    public function exportARInvoiceDetail()
    {
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        $data = [
            'startDate' => $this->startDate,
            'endDate' => $this->endDate,
            'type' => $this->type,
            'checkboxes' => $this->checkboxes,
        ];
        if ($this->startDate === null) {
            $filename = "AR Invoice Report - {$now}.xlsx";
        } else {
            $filename = "AR Invoice Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        $this->dispatch('refreshjs');

        return Excel::download(new ExportARInvoiceDetail($data), $filename);
    }

    public function print($code)
    {
        if ($this->processing) return;
        $this->processing = true;

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);

            $printer->setTextSize(1, 1);

            $datainvoice = DetailInvoice::where('invoice', $code)->get();
            $invoice = ModelsInvoice::where('no', $code)->first();
            $promo = DB::table('Luv2_promo')->where('invoice', $invoice->no)->first();
            $voucher = [];
            if ($promo) {
                $voucher = DB::table('Luv2_promo_voucher')->where('no', $promo->no)->first();
            }

            $changeFormatted = number_format(empty($invoice->change) ? 0 : $invoice->change, 2);
            $datafirst = DetailInvoice::where('invoice', $code)->first();

            if ($invoice->payment === "Multi") {
                $note = json_decode($invoice['note'], true);
                $cash = $note['cash'];
                $card = $note['transfer'];
                $change = 0;
            } elseif ($invoice->payment === "Card") {
                $note = json_decode($invoice['note'], true);
                $cash = 0;
                $card = $note['transfer'];
                $change = $invoice->change;
            } elseif ($invoice->payment === "Cash") {
                $cash = $invoice->paid;
                $card = 0;
                $change = $invoice->change;
            } elseif ($invoice->payment === "Qris") {
                $cash = 0;
                $card = $invoice->paid;
                $change = $invoice->change;
            }

            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier : " . $user->name;
            $billNo = "Bill No : " . $invoice->no;
            $date = "Date    : " . $invoice->created_at;
            if (!isset($datafirst->sales->position) || $datafirst->sales->position === '') {
                $handledBy = "Handled by : " . $datafirst->sales->name;
            } else {
                $handledBy = "Handled by : " . $datafirst->sales->position;
            }
            $cash = $cash ?? 0; // Using the null coalescing operator to handle undefined variables
            $card = $card ?? 0;
            $change = $change ?? 0;

            foreach ($datainvoice as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $items[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                    'nprice' => $cartItem['nprice'],
                    'discount' => $cartItem['disc'],
                ];
            }
            $subTotal = array_reduce($items, function ($carry, $item) {
                if ($item['nprice'] >= 0) {
                    return $carry + $item['nprice'] * $item['qty'];
                }
                return $carry;
            }, 0);

            $grandTotal = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            if ($invoice->cashback !== 'N') {
                $getvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $getvoucher->value;
            }

            $discount = array_reduce($items, function ($carry, $item) {
                return ($carry + $item['nprice'] - $item['price']);
            }, 0);

            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if ($invoice->id_member != null || $invoice->id_member != '') {
                $member = Member::where('code', $invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$date\n$membername\n");
            } else {
                $printer->text("$manager\n$billNo\n$date\n");
            }
            // if ($voucher) {
            //     $printer->text("Voucher : " . $voucher->voucher . "\n");
            // }
            $printer->text("---------------------------------------\n");

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            $totalSelisih = 0; // Initialize the total variable

            foreach ($items as $item) {
                if ($item['discount'] === null || $item['discount'] == 0) {
                    if ($item['price'] < 0) {
                        $formattedPrice = '(' . number_format($item['price'] * $item['qty'], 2) . ')'; // Ensure the negative number is properly formatted
                    } else {
                        $formattedPrice = number_format($item['price'] * $item['qty'], 2);
                    }
                    if($item['price'] < $item['nprice']){
                        $selisih = $item['nprice'] - $item['price'];
                        $printer->text(sprintf(
                            "%-15s %5d   %12s\n",
                            $item['name'],
                            $item['qty'],
                            number_format($item['nprice'] * $item['qty'], 2)
                        ));
                        $printer->setFont(Printer::FONT_B);
                        $printer->setTextSize(1, 1);
                        $printer->text(sprintf(
                            "%36s\n",
                            "(" . number_format($selisih, 2) . ")"
                        ));
                    }else{
                        $printer->text(sprintf(
                            "%-15s %5d   %12s\n",
                            $item['name'],
                            $item['qty'],
                            $formattedPrice
                        ));
                    }
                } else {
                    $selisih = $item['nprice'] - $item['price'];
                    $printer->text(sprintf(
                        "%-15s %5d   %12s\n",
                        $item['name'],
                        $item['qty'],
                        number_format($item['nprice'] * $item['qty'], 2)
                    ));
                    $printer->setFont(Printer::FONT_B);
                    $printer->setTextSize(1, 1);
                    $printer->text(sprintf(
                        "%36s\n",
                        "(" . number_format($selisih * $item['qty'], 2) . ")"
                    ));
                    $totalSelisih += $selisih * $item['qty'];
                }
            }

            // Print Information card
            if ($invoice->payment === "Card" || $invoice->payment === "Multi") {
                $note = json_decode($invoice->note, true);
                $printer->text("---------------------------------------\n");
                $name = "Name        : " . $note['nama_pemegang_kartu'];
                $nocard = "Card Number : " . $note['nomor_kartu'];
                $printer->text("$nocard\n");
                $printer->text("$name\n");
            }

            $printer->setJustification(0);

            $printer->text("---------------------------------------\n");
            $padding = 14; // Number of spaces before the text
            $subTotal = "SubTotal   : " . number_format($subTotal, 2);
            $discount = "Discount   : " . number_format($totalSelisih, 2);
            $grandTotal = "GrandTotal : " . number_format($grandTotal, 2);
            if ($invoice->cashback !== 'N') {
                $getvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $getvoucher->value;
                $voucherdisc = "Cashback   : " . number_format($vouchervalue, 2);
                $rightAlignedVoucher = str_repeat(' ', $padding) . $voucherdisc;
            }

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $rightAlignedDiscount = str_repeat(' ', $padding) . $discount;
            $rightAlignedGrandTotal = str_repeat(' ', $padding) . $grandTotal;

            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("$rightAlignedDiscount\n");
            if ($invoice->cashback !== 'N') {
                $printer->text("$rightAlignedVoucher\n");
            }
            $printer->text("$rightAlignedGrandTotal\n");


            // $printer->text("---------------------------------------\n");
            $cash = "Cash       : " . number_format($cash, 2);
            $card = "Card       : " . number_format($card, 2);
            $change = "Change     : " . $changeFormatted;
            // Add padding before the text to ensure it starts at character 12
            $rightAlignedCash = str_repeat(' ', $padding) . $cash;
            $rightAlignedCard = str_repeat(' ', $padding) . $card;
            $rightAlignedChange = str_repeat(' ', $padding) . $change;


            $printer->text("$rightAlignedCard\n");
            $printer->text("$rightAlignedCash\n");
            $printer->text("$rightAlignedChange\n");

            // Reset text justification to default (centered)
            $printer->setJustification();

            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            //Voucher
            if ($voucher) {
                $voucherFromDate = Carbon::parse($promo->voucher_from_date)->format('d - M - Y');
                $voucherToDate = Carbon::parse($promo->voucher_to_date)->format('d - M - Y');
                $printer->text("---------------------------------------\n");
                $printer->text("Voucher Cashback : " . $voucher->voucher . "\n");
                $printer->text("Valid From       : " . $voucherFromDate . "\n");
                $printer->text("Valid Until      : " . $voucherToDate . "\n");
            }

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n"); // Print each line with a newline character
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();

            // dd($items, $data, 'Subtotal : '. $subTotal, 'GrandTotal : '. $grandTotal, 'Discount : '. $discount);
            $this->dispatch('refresh');
            $this->dispatch('refreshjs');
            sleep(2);
            $this->processing = false;
        } catch (Exception $e) {
            // $this->refreshBrowser();
            dd($e);
        }
    }

    public function clickSync($code)
    {
        $this->isloadingsync = true;
        $invoice = ModelsInvoice::where('no', $code)->first();
        if ($invoice->sandbox == 'Y') {
            $this->dispatch('prosesSyncSandbox', $code);
        } else {
            $this->dispatch('prosesSync', $code);
        }
    }

    public function clickSyncReturn($code)
    {
        $this->isloadingreturn = true;
        $this->dispatch('prosesSyncReturn', $code);
    }


    #[On('prosesSync')]
    public function sync($code)
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoice = DetailInvoice::where('invoice', $code)->get();
        $invoice = ModelsInvoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('invoice', $code)->first();
        $idsales = $getsales->id_sales;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        }

        foreach ($detailinvoice as $data) {
            $syncItems[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => $data->qty,
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => $data->total_price,
                    'WhsCode' => $setting->wh_code,
                    'Cost1' => $setting->cost1,
                    'Cost2' => $setting->cost2,
                    'Cost3' => $setting->cost3,
                    'Cost4' => $setting->cost4,
                    'Cost5' => $setting->cost5
                ];
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $data = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "CashAccount" => $cashAccount,
            "CashSum" => $cash,
            "TransferAccount" => $transferAccount,
            "TransferSum" => $card,
            "TransferDate" => $currentDate,
            "DocType" => "C",
            "Lines" => $syncItems,
        ];
        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);


        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if ($responseData[0]['Comments'] == $commentcode) {
            $invoice = ModelsInvoice::where('no', $code)->first();
            $invoice->sync = 'Y';
            //Sandbox change to N
            $invoice->sandbox = 'N';
            DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
            $invoice->save();
            $this->alert('info', 'Invoice already exists on SAP', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshjs');
            $this->dispatch('syncCompletedBrowser');
            $this->dispatch('syncCompleted');
        } else {
            try {
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $whscode = $setting->wh_code;
                $client = new Client();
                $response = $client->post($url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);

                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($errorCode);
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice = ModelsInvoice::where('no', $code)->first();
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
                $this->dispatch('refreshjs');
            } catch (Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->dispatch('refreshBrowser');
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
            }
        }
        $this->isloadingsync = false;
    }

    #[On('prosesSyncSandbox')]
    public function syncSandbox($code)
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoice = DetailInvoice::where('invoice', $code)->get();
        $invoice = ModelsInvoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('invoice', $code)->first();
        $idsales = $getsales->id_sales;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        }

        foreach ($detailinvoice as $data) {
            $checkItems[] =
                [
                    'ItemCode' => $data->code,
                    'CodeBars' => $data->barcode,
                ];
        }

        foreach ($checkItems as $item) {
            $response = Http::post($url . '/api/search', [
                "Select" => "\"ItemCode\" ",
                "From" => "OITM",
                "Where" => "\"ItemCode\"='" . $item['ItemCode'] . "';",
            ]);
            $jsonData1 = $response->json();
            $itemcode = $item['ItemCode'];
            if ($jsonData1[0]['ItemCode'] == '') {
                $response2 = Http::post($url . '/api/search', [
                    "Select" => "\"CodeBars\" , \"ItemCode\", \"ItemName\"",
                    "From" => "OITM",
                    "Where" => "\"CodeBars\"='" . $item['CodeBars'] . "';",
                ]);
                $jsonData2 = $response2->json();
                if ($jsonData2[0]['CodeBars'] != '') {
                    $item = DB::table('Luv2_item')->where('barcode', $jsonData2[0]['CodeBars'])->get();
                    if ($item->count() > 1) {
                        $existitem = DB::table('Luv2_item')
                            ->where('barcode', $jsonData2[0]['CodeBars'])
                            ->whereNot('code', $itemcode)
                            ->first();

                        DB::table('Luv2_item')
                            ->where('code', $itemcode)
                            ->where('barcode', $jsonData2[0]['CodeBars'])
                            ->delete();

                        DB::table('Luv2_item_pricelist')
                            ->where('item_code', $itemcode)
                            ->delete();

                        DB::table('Luv2_detailinvoice')
                            ->where('invoice', $code)
                            ->where('code', $itemcode)
                            ->update([
                                'code' => $existitem->code,
                                'name' => $existitem->name
                            ]);
                    } else {
                        $item = DB::table('Luv2_item')->where('barcode', $jsonData2[0]['CodeBars'])->first();
                        $itemprice = DB::table('Luv2_item_pricelist')->where('item_code', $item->code)->first();
                        $detailinvoice = DB::table('Luv2_detailinvoice')->where('invoice', $code)->where('code', $itemcode)->first();
                        if ($item) {
                            DB::table('Luv2_item')
                                ->where('barcode', $jsonData2[0]['CodeBars'])
                                ->update([
                                    'code' => $jsonData2[0]['ItemCode'],
                                    'name' => $jsonData2[0]['ItemName']
                                ]);
                        }
                        if ($itemprice) {
                            DB::table('Luv2_item_pricelist')
                                ->where('item_code', $item->code)
                                ->update(['item_code' => $jsonData2[0]['ItemCode']]);
                        }

                        if ($detailinvoice) {
                            DB::table('Luv2_detailinvoice')
                                ->where('invoice', $code)
                                ->where('code', $itemcode)
                                ->update([
                                    'code' => $jsonData2[0]['ItemCode'],
                                    'name' => $jsonData2[0]['ItemName']
                                ]);
                        }
                    }
                }
            }
        }

        $cartData = DetailInvoice::where('invoice', $code)->get();
        foreach ($cartData as $cart) {
            $syncItemsAfterchange[] = [
                'ItemCode' => $cart->code,
                'Quantity' => $cart->qty,
                'UnitPrice' => $cart->nprice,
                'LineTotal' => $cart->total_price,
                'WhsCode' => $setting->wh_code,
                'Cost1' => $setting->cost1,
                'Cost2' => $setting->cost2,
                'Cost3' => $setting->cost3,
                'Cost4' => $setting->cost4,
                'Cost5' => $setting->cost5
            ];
        }

        $lines = [];
        foreach ($syncItemsAfterchange as $item) {
            $lines[] = $item;
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $data = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "CashAccount" => $cashAccount,
            "CashSum" => $cash,
            "TransferAccount" => $transferAccount,
            "TransferSum" => $card,
            "TransferDate" => $currentDate,
            "DocType" => "C",
            "Lines" => $lines,
        ];

        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);


        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if ($responseData[0]['Comments'] == $commentcode) {
            $invoice = ModelsInvoice::where('no', $code)->first();
            $invoice->sync = 'Y';
            //Sandbox change to N
            $invoice->sandbox = 'N';
            DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
            $invoice->save();
            $this->alert('info', 'Invoice already exists on SAP', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshjs');
            $this->dispatch('syncCompletedBrowser');
            $this->dispatch('syncCompleted');
        } else {
            try {
                // dd($data);
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $whscode = $setting->wh_code;
                $client = new Client();
                $response = $client->post($url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);

                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($errorCode);
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice = ModelsInvoice::where('no', $code)->first();
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
                $this->dispatch('refreshjs');
            } catch (Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->dispatch('refreshBrowser');
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
            }
        }
        $this->isloadingsync = false;
    }

    #[On('prosesSyncReturn')]
    public function syncreturn($code)
    {

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoicememo = DetailInvoice::where('invoice', $code)->where('status', 1)->get();
        $detailinvoicear = DetailInvoice::where('invoice', $code)->where('status', 0)->get();

        $invoice = ModelsInvoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('invoice', $code)->first();
        $idsales = $getsales->id_sales;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "") { //mzhilangkan
            $cash = 0;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        }


        foreach ($detailinvoicememo as $data) {
            $syncItemsmemo[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => ltrim($data->qty, '-'),
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => ltrim($data->total_price, '-'),
                    'WhsCode' => $setting->wh_code,
                    'Cost1' => $setting->cost1,
                    'Cost2' => $setting->cost2,
                    'Cost3' => $setting->cost3,
                    'Cost4' => $setting->cost4,
                    'Cost5' => $setting->cost5
                ];
        }
        foreach ($detailinvoicear as $data) {
            $syncItemsar[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => $data->qty,
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => $data->total_price,
                    'WhsCode' => $setting->wh_code,
                    'Cost1' => $setting->cost1,
                    'Cost2' => $setting->cost2,
                    'Cost3' => $setting->cost3,
                    'Cost4' => $setting->cost4,
                    'Cost5' => $setting->cost5
                ];
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $datamemo = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "DocType" => "C",
            "Lines" => $syncItemsmemo,
        ];

        if ($invoice->subtotal <= 0) { //mztambahin jika kurang dari atau sama dengan 0
            $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "Lines" => $syncItemsar,
                "CreditMemo" => $datamemo,
            ];
        } else {
            $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "CashAccount" => $cashAccount,
                "CashSum" => $cash,
                "TransferAccount" => $transferAccount,
                "TransferSum" => $card,
                "TransferDate" => $currentDate,
                "DocType" => "C",
                "Lines" => $syncItemsar,
                "CreditMemo" => $datamemo,
            ];
        }

        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);

        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if ($responseData[0]['Comments'] == $commentcode) {
            $invoice = ModelsInvoice::where('no', $code)->first();
            $invoice->sync = 'Y';
            //Sandbox change to N
            $invoice->sandbox = 'N';
            DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
            $invoice->save();
            $this->alert('info', 'Invoice already exists on SAP', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshBrowser');
            $this->dispatch('syncCompletedBrowser');
            $this->dispatch('syncCompleted');
        } else {
            try {
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $client = new Client();
                $route = ($invoice->subtotal <= 0) ? '/api/addarexchange' : '/api/addarexchangepayment'; //mztambahin jika kurang dari atau sama dengan 0

                $response = $client->post($url . $route, [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);


                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice = ModelsInvoice::where('no', $code)->first();
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    // $this->creditmemo($code, $commentcode, $datamemo);
                }
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
                $this->dispatch('refreshBrowser');
            } catch (Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->dispatch('refreshBrowser');
                $this->dispatch('syncCompletedBrowser');
                $this->dispatch('syncCompleted');
            }
        }
        $this->isloadingreturn = false;
    }

    public function syncAll()
    {
        $invoices = ModelsInvoice::where('sync', 'N')

            ->with('detailInvoices')->get();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();

        foreach ($invoices as $invoice) {
            $date = date_create($invoice->date);
            $formattedDate = date_format($date, 'Y-m-d');
            $currentDate = Carbon::now()->format('Y-m-d');
            $getsales = DetailInvoice::where('invoice', $invoice->no)->first();
            $idsales = $getsales->id_sales;

            if ($invoice->payment === "Multi") {
                $note = json_decode($invoice['note'], true);
                $cash = $note['cash'];
                $card = $note['transfer'];
                $cashAccount = $setting->cashacc;
                $transferAccount = $setting->cardacc;
            } elseif ($invoice->payment === "Card") {
                $note = json_decode($invoice['note'], true);
                $cash = 0;
                $card = $note['transfer'];
                $cashAccount = '';
                $transferAccount =  $setting->cardacc;
            } elseif ($invoice->payment === "Cash") {
                $cash = $invoice->must_paid;
                $card = 0;
                $cashAccount = $setting->cashacc;
                $transferAccount = '';
            } elseif ($invoice->payment === "Qris") {
                $cash = 0;
                $card = $invoice->must_paid;
                $cashAccount = '';
                $transferAccount = $setting->cardacc;
            }
            $detailInvoices = $invoice->detailInvoices;
            foreach ($detailInvoices as $data) {
                $syncItems[] =
                    [
                        'ItemCode' => $data->code,
                        'Quantity' => $data->qty,
                        'UnitPrice' => $data->nprice,
                        'LineTotal' => $data->disc,
                        'WhsCode' => $setting->wh_code,
                        'Cost1' => $setting->cost1,
                        'Cost2' => $setting->cost2,
                        'Cost3' => $setting->cost3,
                        'Cost4' => $setting->cost4,
                        'Cost5' => $setting->cost5
                    ];
            }
            $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $invoice->no,
                "BPLId" => $setting->bpl_id,
                "CashAccount" => $cashAccount,
                "CashSum" => $cash,
                "TransferAccount" => $transferAccount,
                "TransferSum" => $card,
                "TransferDate" => $currentDate,
                "DocType" => "C",
                "Lines" => $syncItems,
            ];
            try {
                $client = new Client();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $response = $client->post($url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);

                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($data, $responseData);
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice->sync = 'Y';
                    //Sandbox change to N
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoice->no)->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
                $this->dispatch('syncCompletedBrowserAll');
                $this->dispatch('syncCompleted');
            } catch (Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function sapGetTrans()
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $userId = auth()->user()->id;
        $url = $setting->url;
        $whscode = $setting->wh_code;
        try {
            $response = Http::post($url . '/api/search', [
                "Select" => "\"Warehouse\" as \"whs_code\",\"BASE_REF\" as \"no_trans\",\"TransType\" as \"tipe\",\"InQty\"-\"OutQty\" as \"qty\",\"DocDate\" as \"date\",\"ItemCode\" as \"item_code\",\"DocLineNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM",
                "Where" => "\"Warehouse\"='" . $whscode . "' and \"TransType\" not in ('13','67');",
            ]);
            $responseperiod = Http::post($url . '/api/search', [
                "Select" => "\"Warehouse\" as \"whs_code\",\"BASE_REF\" as \"no_trans\",\"TransType\" as \"tipe\",\"InQty\"-\"OutQty\" as \"qty\",\"DocDate\" as \"date\",\"ItemCode\" as \"item_code\",\"DocLineNum\" as \"linenum\",'" . $userId . "' as \"id_user\" ",
                "From" => "OINM",
                "Where" => "\"Warehouse\"='" . $whscode . "' and \"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' and \"TransType\" not in ('13','67');",
            ]);
            $responseBody = $response->getBody()->getContents();
            $responseData = json_decode($responseBody, true);

            if ($response->successful()) {
                $jsonData = $response->json();

                ItemTransTemp::where('id_user', $userId)->delete();

                $chunks = array_chunk($jsonData, 1000);

                foreach ($chunks as $chunk) {
                    $insertData = [];

                    foreach ($chunk as $item) {
                        $insertData[] = [
                            'whs_code' => $item['whs_code'],
                            'no_trans' => $item['no_trans'],
                            'tipe' => $item['tipe'],
                            'qty' => $item['qty'],
                            'date' => $item['date'],
                            'canceled' => 'N',
                            'item_code' => $item['item_code'],
                            'linenum' => $item['linenum'],
                            'id_user' => $item['id_user'],
                        ];
                    }

                    DB::table('Luv2_item_trans_temp')->insert($insertData);
                }

                #insert item trans
                DB::statement("
                        INSERT INTO \"Luv2_item_trans\" (\"whs_code\", \"no_trans\", \"tipe\", \"qty\", \"date\", \"canceled\", \"item_code\", \"linenum\") 
                        SELECT \"whs_code\", \"no_trans\", \"tipe\", \"qty\", \"date\", \"canceled\", \"item_code\", \"linenum\"
                        FROM \"Luv2_item_trans_temp\"
                        WHERE NOT EXISTS (
                            SELECT 1 FROM \"Luv2_item_trans\" WHERE \"Luv2_item_trans\".\"no_trans\" = \"Luv2_item_trans_temp\".\"no_trans\" and \"Luv2_item_trans\".\"tipe\" = \"Luv2_item_trans_temp\".\"tipe\" and \"Luv2_item_trans\".\"linenum\" = \"Luv2_item_trans_temp\".\"linenum\"
                        ) and \"Luv2_item_trans_temp\".\"id_user\"='" . $userId . "' 
                    ");

                ItemTransTemp::where('id_user', $userId)->delete();
                $this->alert('success', 'Data synchrone succesfully', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (\Throwable $th) {
            $this->alert('error', 'No Internet Connection to Sync', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function printreturn($code)
    {
        $invoice = ModelsInvoice::where('no', $code)->with('detailInvoices')->first();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);
            $datafirst = DetailInvoice::where('invoice', $code)->first();

            // Set the font size
            $printer->setTextSize(1, 1);

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier   : " . Auth::user()->name;
            $billNo = "Bill No   : " . $invoice->no_inv;
            $returNo = "Return No : " . $invoice->no;
            $date = "Date      : " . $invoice->created_at;
            if (!isset($datafirst->sales->position) || $datafirst->sales->position === '') {
                $handledBy = "Handled by : " . $datafirst->sales->name;
            } else {
                $handledBy = "Handled by : " . $datafirst->sales->position;
            }
            // Define your item list (replace this with your actual item data)
            $itemsreturn = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                // Check if qty is not negative (-)
                if ($cartItem['qty'] <= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $itemsreturn[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $items = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                if ($cartItem['qty'] >= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $items[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $subTotalreturn = array_reduce($itemsreturn, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $subTotalitems = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if ($invoice->id_member != null || $invoice->id_member != '') {
                $member = Member::where('code', $invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$returNo\n$date\n$membername\n");
            } else {
                $printer->text("$manager\n$billNo\n$returNo\n$date\n");
            }
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEM RETURN* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($itemsreturn as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print totals

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotal = "SubTotal  : " . number_format($subTotalreturn, 2);


            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEMS* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($items as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotals = "SubTotal  : " . number_format($subTotalitems, 2);

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotals;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n");
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            $this->dispatch('printernotfound');
        }
        // dd('No money ' , $invoice);
    }
    public function printreturnwithmoney($code)
    {
        $invoice = ModelsInvoice::where('no', $code)->with('detailInvoices')->first();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $change = $invoice->change ?? 0;
        $changeFormatted = number_format($change > 0 ? $change : 0, 2);
        $datafirst = DetailInvoice::where('invoice', $code)->first();

        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);

            // Set the font size
            $printer->setTextSize(1, 1);

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier   : " . Auth::user()->name;
            $billNo = "Bill No   : " . $invoice->no_inv;
            $returNo = "Return No : " . $invoice->no;
            $date = "Date      : " . $invoice->created_at;
            $handledBy = "Handled by : " . $datafirst->sales->name;
            // Define your item list (replace this with your actual item data)
            if ($invoice->payment === "Multi") {
                $note = json_decode($invoice['note'], true);
                $cash = $note['cash'];
                $card = $note['transfer'];
                $change = 0;
            } elseif ($invoice->payment === "Card") {
                $note = json_decode($invoice['note'], true);
                $cash = 0;
                $card = $note['transfer'];
                $change = $invoice->change;
            } elseif ($invoice->payment === "Cash") {
                $cash = $invoice->paid;
                $card = 0;
                $change = $invoice->change;
            } elseif ($invoice->payment === "Qris") {
                $cash = 0;
                $card = $invoice->paid;
                $change = $invoice->change;
            }

            $itemsreturn = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                if ($cartItem['qty'] <= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $itemsreturn[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $items = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                if ($cartItem['qty'] >= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $items[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $subTotalreturn = array_reduce($itemsreturn, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $subTotalitems = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $grandTotal = $subTotalitems - $subTotalreturn;
            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if ($invoice->id_member != null || $invoice->id_member != '') {
                $member = Member::where('code', $invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$returNo\n$date\n$membername\n");
            } else {
                $printer->text("$manager\n$billNo\n$returNo\n$date\n");
            }
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEM RETURN* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($itemsreturn as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }



            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotal = "SubTotal  : " . number_format($subTotalreturn, 2);


            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEMS* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($items as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print Information card
            if ($invoice->payment === "Card" || $invoice->payment === "Multi") {
                $note = json_decode($invoice->note, true);
                $printer->text("---------------------------------------\n");
                $name = "Name        : " . $note['nama_pemegang_kartu'];
                $nocard = "Card Number : " . $note['nomor_kartu'];
                $printer->text("$nocard\n");
                $printer->text("$name\n");
            }

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotals = "SubTotal  : " . number_format($subTotalitems, 2);
            $grandTotal = "GrandTotal: " . number_format($grandTotal, 2);

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotals;
            $rightAlignedGrandTotal = str_repeat(' ', $padding) . $grandTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("$rightAlignedGrandTotal\n");
            $cash = "Cash      : " . number_format($cash, 2);
            $card = "Card      : " . number_format($card, 2);
            $change = "Change    : " . $changeFormatted;
            // Add padding before the text to ensure it starts at character 12
            $rightAlignedCash = str_repeat(' ', $padding) . $cash;
            $rightAlignedCard = str_repeat(' ', $padding) . $card;
            $rightAlignedChange = str_repeat(' ', $padding) . $change;


            $printer->text("$rightAlignedCard\n");
            $printer->text("$rightAlignedCash\n");
            $printer->text("$rightAlignedChange\n");
            $printer->text("---------------------------------------\n");


            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n");
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            // dd($e);
            $this->dispatch('printernotfound');
        }
    }

    // #[On('getDetailInvoice')]
    public function dispatchToDetail($data)
    {
        $this->invoiceNo = true;
        $datadetail = DB::table('Luv2_detailinvoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_detailinvoice.id_sales', '=', DB::raw('CAST("Luv2_salesemp"."code" AS VARCHAR)'))
            ->leftJoin('Luv2_member', 'Luv2_detailinvoice.id_member', '=', 'Luv2_member.code')
            ->where('Luv2_detailinvoice.invoice', $data)
            ->select(
                'Luv2_detailinvoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_member.name as member_name'
            )
            ->get();


        $this->datadetail = $datadetail;
        $this->dispatch('modalDetail', $this->datadetail);
        $this->dispatch('toDetail');
    }

    #[On('toDetail')]
    public function openModalnya()
    {

        $this->dispatch('refreshjs');
        $this->dispatch('openModal');
    }

    #[On('closeModal')]
    public function tutupModalnya()
    {
        $this->invoiceNo = false;
        $this->datadetail = '';
        $this->dispatch('closeModalweb');
    }

    public function clickgetSAPInvoice()
    {
        $this->loadingsap = true;
        $this->dispatch('getSAPInvoice');
    }

    #[On('redirect')]
    public function finishh()
    {
        sleep(1);
        return redirect()->route('report.reportinvoicereturnsale');
    }

    public function selectType()
    {
        $this->selectedType = true;
        $this->dispatch('refreshjs');
    }

    public function tesapi2()
    {
        $defaultFields = ['code', 'barcode', 'name', 'group_code', 'status', 'created_at', 'updated_at', 'id', 'inventory', 'sales', 'purchase', 'active'];
        $tableName = 'Luv2_item_testing';
        $columns = Schema::getColumnListing($tableName);

        dd($columns);
    }
    public function toPrint($no)
    {
        $this->dispatch('toPrintBrowser', $no);
    }
}
