<?php

namespace App\Livewire\Pos\Item;

use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class ItemTable extends Component
{
    public $items;
    public $promoitem;

    public function mount($item)
    {
        ini_set('max_execution_time', '1000');
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $id_pricelist = $wh->id_pricelist;
        $this->items = $item;
    }

    public function dispatchToDetailItem($code)
    {
        $this->promoitem = DB::table('Luv2_promo')
            ->join('Luv2_promo_item', 'Luv2_promo.no', '=', 'Luv2_promo_item.no')
            ->where('Luv2_promo_item.item_code', $code)
            ->distinct('Luv2_promo.no') // Retrieve distinct records based on the 'no' column
            ->orderBy('Luv2_promo.no')
            ->get();
        $this->dispatch('refreshjs');
    }

    public function clearPromo()
    {
        $this->promoitem = [];
        $this->dispatch('refreshjs');

    }


    public function render()
    {
        return view('livewire.pos.item.item-table');
    }
}
