<?php

namespace App\Livewire;

use Livewire\Component;

class Clock extends Component
{
    public $formattedTime;

    protected $listeners = ['updateTime'];

    public function mount()
    {
        $this->formattedTime = now()->format('H:i:s');
    }

    public function updateTime($time)
    {
        $this->formattedTime = $time;
    }

    public function render()
    {
        return view('livewire.clock');
    }
}
