<?php

namespace App\Livewire\Cashier;

use App\Models\Cart;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Display extends Component
{
    public $cart = [] ;

    public function refreshSession()
    {
        // This method doesn't need to do anything, it just keeps the session alive
    }
    
    public function render()
    {
        
        $user = Auth::user();

        $cartData = DB::table('Luv2_carts')->where('id_user', $user->id)
        ->orderBy('grouping', 'desc')
        ->orderBy('promo', 'desc')
        ->orderBy('pack', 'asc')
        ->get();

        $this->cart = $cartData;
        return view('livewire.cashier.display', [
            'carts' => $cartData,
        ]);
    }
}
