<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ExportReturnDetail implements FromView, ShouldAutoSize, WithEvents
{
    /**
    * @return \Illuminate\Support\Collection
    */
    private $invoices;
    private $invoicesreturn;
    public $UDF;
    public $selectFields = [];

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $lastColumn = $event->sheet->getHighestColumn();
                $lastRow = $event->sheet->getHighestRow();
        
                $range = 'C3:' . $lastColumn . $lastRow;
                $rangem = 'M3:' . $lastColumn . $lastRow;
                $rangen = 'N3:' . $lastColumn . $lastRow;
                $rangeo = 'O3:' . $lastColumn . $lastRow;
               
                $event->sheet->getStyle($rangem)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangen)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangeo)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($range)->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '#000000'],
                        ],
                    ],
                ]);
            }
        ];
    }
    public function __construct($invoicesreturn, $invoices)
    {
        $this->invoicesreturn = $invoicesreturn;
        $this->invoices = $invoices;

        $fields = DB::getSchemaBuilder()->getColumnListing('Luv2_item');

        $this->selectFields = [];

        foreach ($fields as $field) {
            if (strpos($field, 'U_') === 0) {
                $this->selectFields[] = $field;
            }
        }

        if (!empty($selectFields)) {
            $this->UDF = false;
        } else {
            $this->UDF = true;
        }
    }

        public function view():View
        {
            return view('export.tabledetailreturnsale', [
                'invoices' => $this->invoices,
                'invoicesreturn' => $this->invoicesreturn,
                'udf' => $this->UDF,
                'field' => $this->selectFields,
            ]);
        }
}
